/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tio.core.intf.Packet;

public class HttpPacket
extends Packet {
    private static final long serialVersionUID = 3903186670675671956L;
    private Map<String, Serializable> props = new ConcurrentHashMap<String, Serializable>();
    protected byte[] body;
    private String headerString;
    protected Map<String, String> headers = new HashMap<String, String>();

    public static void main(String[] args) {
    }

    public Object getAttribute(String key) {
        return this.props.get(key);
    }

    public Object getAttribute(String key, Serializable defaultValue) {
        Serializable ret = this.props.get(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public void removeAttribute(String key) {
        this.props.remove(key);
    }

    public void setAttribute(String key, Serializable value) {
        this.props.put(key, value);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void removeHeader(String key, String value) {
        this.headers.remove(key);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setHeaderString(String headerString) {
        this.headerString = headerString;
    }
}

