/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import com.xiaoleilu.hutool.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.utils.cache.ICache;

public class HttpConfig {
    public static final String SESSION_CACHE_NAME = "tio-h-s";
    public static final String SESSION_COOKIE_NAME = "big-tio";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800L;
    public static final int MAX_LIVETIME_OF_STATICRES = 600;
    public static final int MAX_LENGTH_OF_BOUNDARY = 256;
    public static final int MAX_LENGTH_OF_MULTI_HEADER = 128;
    public static final int MAX_LENGTH_OF_MULTI_BODY = 0x1400000;
    private String bindIp = null;
    private Integer bindPort = 80;
    private String serverInfo = "tio-httpserver/0.0.1";
    private String charset = "utf-8";
    private ICache sessionStore = null;
    private String contextPath = "";
    private String suffix = "";
    private String[] allowDomains = null;
    private String sessionCacheName = "tio-h-s";
    private long sessionTimeout = 1800L;
    private String sessionCookieName = "big-tio";
    private int maxLiveTimeOfStaticRes = 600;
    private String page404 = "/404.html";
    private String page500 = "/500.html";
    private ISessionIdGenerator sessionIdGenerator;
    private HttpRequestHandler httpRequestHandler;
    private boolean isProxied = false;
    private File pageRoot = null;

    public static void main(String[] args) {
    }

    public HttpConfig(Integer bindPort, Long sessionTimeout, String contextPath, String suffix) {
        this.bindPort = bindPort;
        if (sessionTimeout != null) {
            this.sessionTimeout = sessionTimeout;
        }
        if (contextPath == null) {
            contextPath = "";
        }
        this.contextPath = contextPath;
        if (suffix == null) {
            suffix = "";
        }
        this.suffix = suffix;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public Integer getBindPort() {
        return this.bindPort;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getMaxLiveTimeOfStaticRes() {
        return this.maxLiveTimeOfStaticRes;
    }

    public String getPage404() {
        return this.page404;
    }

    public String getPage500() {
        return this.page500;
    }

    public File getPageRoot() {
        return this.pageRoot;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getSessionCacheName() {
        return this.sessionCacheName;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public ISessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    public ICache getSessionStore() {
        return this.sessionStore;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setMaxLiveTimeOfStaticRes(int maxLiveTimeOfStaticRes) {
        this.maxLiveTimeOfStaticRes = maxLiveTimeOfStaticRes;
    }

    public void setPage404(String page404) {
        this.page404 = page404;
    }

    public void setPage500(String page500) {
        this.page500 = page500;
    }

    public void setPageRoot(String pageRoot) throws IOException {
        if (pageRoot == null) {
            return;
        }
        this.pageRoot = StringUtils.startsWithIgnoreCase((CharSequence)pageRoot, (CharSequence)"classpath:") ? new File(FileUtil.getAbsolutePath((String)pageRoot)) : new File(pageRoot);
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setSessionCacheName(String sessionCacheName) {
        this.sessionCacheName = sessionCacheName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setSessionIdGenerator(ISessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    public void setSessionStore(ICache sessionStore) {
        this.sessionStore = sessionStore;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public void setHttpRequestHandler(HttpRequestHandler httpRequestHandler) {
        this.httpRequestHandler = httpRequestHandler;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String[] getAllowDomains() {
        return this.allowDomains;
    }

    public void setAllowDomains(String[] allowDomains) {
        this.allowDomains = allowDomains;
    }

    public boolean isProxied() {
        return this.isProxied;
    }

    public void setProxied(boolean isProxied) {
        this.isProxied = isProxied;
    }
}

