/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class GroupStat
implements Serializable {
    private static final long serialVersionUID = -6988655941470121164L;
    private AtomicLong closed = new AtomicLong();
    private AtomicLong receivedPackets = new AtomicLong();
    private AtomicLong receivedBytes = new AtomicLong();
    private AtomicLong receivedTcps = new AtomicLong();
    private AtomicLong handledPackets = new AtomicLong();
    private AtomicLong handledPacketCosts = new AtomicLong();
    private AtomicLong handledBytes = new AtomicLong();
    private AtomicLong sentPackets = new AtomicLong();
    private AtomicLong sentBytes = new AtomicLong();

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public AtomicLong getClosed() {
        return this.closed;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public void setClosed(AtomicLong closed) {
        this.closed = closed;
    }

    public void setHandledBytes(AtomicLong handledBytes) {
        this.handledBytes = handledBytes;
    }

    public void setReceivedBytes(AtomicLong receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public void setReceivedTcps(AtomicLong receivedTcps) {
        this.receivedTcps = receivedTcps;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.get() / this.handledPackets.get();
        }
        return 0.0;
    }
}

