/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import cn.hutool.core.io.FileUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class SslConfig {
    private InputStream keyStoreInputStream = null;
    private InputStream trustStoreInputStream = null;
    private String passwd = null;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;

    private SslConfig(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        this.keyStoreInputStream = keyStoreInputStream;
        this.trustStoreInputStream = trustStoreInputStream;
        this.passwd = passwd;
        this.init();
    }

    public static SslConfig forServer(String keyStoreFile, String trustStoreFile, String passwd) throws Exception {
        FileInputStream keyStoreInputStream = null;
        FileInputStream trustStoreInputStream = null;
        keyStoreInputStream = StringUtils.startsWithIgnoreCase((CharSequence)keyStoreFile, (CharSequence)"classpath:") ? new FileInputStream(FileUtil.getAbsolutePath((String)keyStoreFile)) : new FileInputStream(keyStoreFile);
        trustStoreInputStream = StringUtils.startsWithIgnoreCase((CharSequence)trustStoreFile, (CharSequence)"classpath:") ? new FileInputStream(FileUtil.getAbsolutePath((String)trustStoreFile)) : new FileInputStream(trustStoreFile);
        SslConfig sslConfig = new SslConfig(keyStoreInputStream, trustStoreInputStream, passwd);
        return sslConfig;
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        SslConfig sslConfig = new SslConfig(keyStoreInputStream, trustStoreInputStream, passwd);
        return sslConfig;
    }

    public static SslConfig forClient() throws Exception {
        SslConfig sslConfig = new SslConfig(null, null, null);
        return sslConfig;
    }

    public void init() throws Exception {
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        char[] passChars = null;
        if (this.passwd != null) {
            passChars = this.passwd.toCharArray();
        }
        if (this.keyStoreInputStream != null) {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(this.keyStoreInputStream, passChars);
        }
        if (this.trustStoreInputStream != null) {
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(this.trustStoreInputStream, passChars);
        }
        this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyManagerFactory.init(keyStore, passChars);
        this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        this.trustManagerFactory.init(trustStore);
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public void setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    public static void main(String[] args) {
    }
}

