/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioHandler;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.stat.ChannelStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class AioClient {
    private static Logger log = LoggerFactory.getLogger(AioClient.class);
    private AsynchronousChannelGroup channelGroup;
    private ClientGroupContext clientGroupContext;

    public AioClient(ClientGroupContext clientGroupContext) throws IOException {
        this.clientGroupContext = clientGroupContext;
        ThreadPoolExecutor groupExecutor = clientGroupContext.getGroupExecutor();
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(groupExecutor);
        this.startHeartbeatTask();
        this.startReconnTask();
    }

    public void asynConnect(Node serverNode) throws Exception {
        this.asynConnect(serverNode, null);
    }

    public void asynConnect(Node serverNode, Integer timeout) throws Exception {
        this.asynConnect(serverNode, null, null, timeout);
    }

    public void asynConnect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        this.connect(serverNode, bindIp, bindPort, null, timeout, false);
    }

    public ClientChannelContext connect(Node serverNode) throws Exception {
        return this.connect(serverNode, null);
    }

    public ClientChannelContext connect(Node serverNode, Integer timeout) throws Exception {
        return this.connect(serverNode, null, 0, timeout);
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, initClientChannelContext, timeout, true);
    }

    private ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout, boolean isSyn) throws Exception {
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        ClientChannelContext channelContext = null;
        boolean isReconnect = initClientChannelContext != null;
        long start = SystemTimer.currentTimeMillis();
        asynchronousSocketChannel = AsynchronousSocketChannel.open(this.channelGroup);
        long end = SystemTimer.currentTimeMillis();
        long iv = end - start;
        if (iv >= 100L) {
            log.error("{}, open \u8017\u65f6:{} ms", channelContext, (Object)iv);
        }
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        InetSocketAddress bind = null;
        if (bindPort != null && bindPort > 0) {
            bind = StringUtils.isNotBlank((CharSequence)bindIp) ? new InetSocketAddress(bindIp, (int)bindPort) : new InetSocketAddress(bindPort);
        }
        if (bind != null) {
            asynchronousSocketChannel.bind(bind);
        }
        channelContext = initClientChannelContext;
        start = SystemTimer.currentTimeMillis();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverNode.getIp(), serverNode.getPort());
        ConnectionCompletionVo attachment = new ConnectionCompletionVo(channelContext, this, isReconnect, asynchronousSocketChannel, serverNode, bindIp, bindPort);
        if (isSyn) {
            Integer realTimeout = timeout;
            if (realTimeout == null) {
                realTimeout = 5;
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            attachment.setCountDownLatch(countDownLatch);
            asynchronousSocketChannel.connect(inetSocketAddress, attachment, this.clientGroupContext.getConnectionCompletionHandler());
            countDownLatch.await(realTimeout.intValue(), TimeUnit.SECONDS);
            return attachment.getChannelContext();
        }
        asynchronousSocketChannel.connect(inetSocketAddress, attachment, this.clientGroupContext.getConnectionCompletionHandler());
        return null;
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, null, timeout);
    }

    public AsynchronousChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public ClientGroupContext getClientGroupContext() {
        return this.clientGroupContext;
    }

    public void reconnect(ClientChannelContext channelContext, Integer timeout) throws Exception {
        this.connect(channelContext.getServerNode(), channelContext.getBindIp(), channelContext.getBindPort(), channelContext, timeout);
    }

    public void setClientGroupContext(ClientGroupContext clientGroupContext) {
        this.clientGroupContext = clientGroupContext;
    }

    private void startHeartbeatTask() {
        final ClientGroupStat clientGroupStat = this.clientGroupContext.getClientGroupStat();
        final ClientAioHandler aioHandler = this.clientGroupContext.getClientAioHandler();
        final String id = this.clientGroupContext.getId();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AioClient.this.clientGroupContext.isStopped()) {
                    long heartbeatTimeout = AioClient.this.clientGroupContext.getHeartbeatTimeout();
                    if (heartbeatTimeout <= 0L) {
                        log.warn("\u7528\u6237\u53d6\u6d88\u4e86\u6846\u67b6\u5c42\u9762\u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u673a\u5236");
                        break;
                    }
                    SetWithLock setWithLock = ((AioClient)AioClient.this).clientGroupContext.connecteds;
                    ReentrantReadWriteLock.ReadLock readLock = setWithLock.getLock().readLock();
                    readLock.lock();
                    try {
                        Set set = (Set)setWithLock.getObj();
                        long currtime = SystemTimer.currentTimeMillis();
                        for (ChannelContext entry : set) {
                            Packet packet;
                            long latestTimeOfSentPacket;
                            ChannelStat stat;
                            long latestTimeOfReceivedByte;
                            long compareTime;
                            long interval;
                            ClientChannelContext channelContext = (ClientChannelContext)entry;
                            if (channelContext.isClosed() || channelContext.isRemoved() || (interval = currtime - (compareTime = Math.max(latestTimeOfReceivedByte = (stat = channelContext.stat).getLatestTimeOfReceivedByte(), latestTimeOfSentPacket = stat.getLatestTimeOfSentPacket()))) < heartbeatTimeout / 2L || (packet = aioHandler.heartbeatPacket()) == null) continue;
                            log.info("{}\u53d1\u9001\u5fc3\u8df3\u5305", (Object)channelContext.toString());
                            Aio.send(channelContext, packet);
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info("[{}]: curr:{}, closed:{}, received:({}p)({}b), handled:{}, sent:({}p)({}b)", new Object[]{id, set.size(), clientGroupStat.getClosed().get(), clientGroupStat.getReceivedPackets().get(), clientGroupStat.getReceivedBytes().get(), clientGroupStat.getHandledPackets().get(), clientGroupStat.getSentPackets().get(), clientGroupStat.getSentBytes().get()});
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    finally {
                        try {
                            readLock.unlock();
                            Thread.sleep(heartbeatTimeout / 4L);
                        }
                        catch (Throwable e) {
                            log.error(e.toString(), e);
                        }
                    }
                }
            }
        }, "tio-timer-heartbeat" + id).start();
    }

    private void startReconnTask() {
        final ReconnConf reconnConf = this.clientGroupContext.getReconnConf();
        if (reconnConf == null || reconnConf.getInterval() <= 0L) {
            return;
        }
        String id = this.clientGroupContext.getId();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!AioClient.this.clientGroupContext.isStopped()) {
                    LinkedBlockingQueue<ChannelContext> queue = reconnConf.getQueue();
                    ClientChannelContext channelContext = null;
                    try {
                        channelContext = (ClientChannelContext)queue.take();
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    if (channelContext == null || channelContext.isRemoved()) continue;
                    SslFacadeContext sslFacadeContext = channelContext.getSslFacadeContext();
                    if (sslFacadeContext != null) {
                        sslFacadeContext.setHandshakeCompleted(false);
                    }
                    long currtime = SystemTimer.currentTimeMillis();
                    long timeInReconnQueue = channelContext.stat.getTimeInReconnQueue();
                    long sleeptime = reconnConf.getInterval() - (currtime - timeInReconnQueue);
                    if (sleeptime > 0L) {
                        try {
                            Thread.sleep(sleeptime);
                        }
                        catch (InterruptedException e) {
                            log.error(e.toString(), (Throwable)e);
                        }
                    }
                    if (channelContext.isRemoved() || !channelContext.isClosed()) continue;
                    ReconnRunnable runnable = new ReconnRunnable(channelContext, AioClient.this);
                    reconnConf.getThreadPoolExecutor().execute(runnable);
                }
            }
        });
        thread.setName("tio-timer-reconnect-" + id);
        thread.setDaemon(true);
        thread.start();
    }

    public boolean stop() {
        boolean ret = true;
        ThreadPoolExecutor groupExecutor = this.clientGroupContext.getGroupExecutor();
        SynThreadPoolExecutor tioExecutor = this.clientGroupContext.getTioExecutor();
        groupExecutor.shutdown();
        tioExecutor.shutdown();
        this.clientGroupContext.setStopped(true);
        try {
            ret = ret && groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info("client resource has released");
        return ret;
    }

    private static class ReconnRunnable
    implements Runnable {
        ClientChannelContext channelContext = null;
        AioClient aioClient = null;

        public ReconnRunnable(ClientChannelContext channelContext, AioClient aioClient) {
            this.channelContext = channelContext;
            this.aioClient = aioClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock closeLock = this.channelContext.getCloseLock();
            ReentrantReadWriteLock.WriteLock writeLock = closeLock.writeLock();
            writeLock.lock();
            try {
                if (!this.channelContext.isClosed()) {
                    return;
                }
                long start = SystemTimer.currentTimeMillis();
                this.aioClient.reconnect(this.channelContext, 2);
                long end = SystemTimer.currentTimeMillis();
                long iv = end - start;
                if (iv >= 100L) {
                    log.error("{},\u91cd\u8fde\u8017\u65f6:{} ms", (Object)this.channelContext, (Object)iv);
                } else {
                    log.info("{},\u91cd\u8fde\u8017\u65f6:{} ms", (Object)this.channelContext, (Object)iv);
                }
                if (this.channelContext.isClosed()) {
                    this.channelContext.setReconnCount(this.channelContext.getReconnCount() + 1);
                    return;
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

