/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelAction;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.ssl.SslUtils;
import org.tio.core.stat.IpStat;
import org.tio.server.AioServer;
import org.tio.server.ServerChannelContext;
import org.tio.server.ServerGroupContext;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.SystemTimer;

public class AcceptCompletionHandler
implements CompletionHandler<AsynchronousSocketChannel, AioServer> {
    private static Logger log = LoggerFactory.getLogger(AcceptCompletionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(AsynchronousSocketChannel asynchronousSocketChannel, AioServer aioServer) {
        try {
            ServerGroupContext serverGroupContext = aioServer.getServerGroupContext();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)asynchronousSocketChannel.getRemoteAddress();
            String clientIp = inetSocketAddress.getHostString();
            List<Long> list = serverGroupContext.ipStats.durationList;
            for (Long v : list) {
                IpStat ipStat = serverGroupContext.ipStats.get(v, clientIp);
                ipStat.getRequestCount().incrementAndGet();
            }
            ServerGroupStat serverGroupStat = serverGroupContext.getServerGroupStat();
            serverGroupStat.getAccepted().incrementAndGet();
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)32768);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)32768);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            ServerChannelContext channelContext = new ServerChannelContext(serverGroupContext, asynchronousSocketChannel);
            channelContext.setClosed(false);
            channelContext.setServerNode(aioServer.getServerNode());
            ServerAioListener serverAioListener = serverGroupContext.getServerAioListener();
            channelContext.getStat().setTimeFirstConnected(SystemTimer.currentTimeMillis());
            channelContext.traceClient(ChannelAction.CONNECT, null, null);
            serverGroupContext.connecteds.add(channelContext);
            serverGroupContext.ips.bind(channelContext);
            if (!SslUtils.isSsl(channelContext)) {
                try {
                    serverAioListener.onAfterConnected(channelContext, true, false);
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
            }
            if (!aioServer.isWaitingStop()) {
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
            }
        }
        catch (Throwable e) {
            log.error("", e);
        }
        finally {
            if (aioServer.isWaitingStop()) {
                log.info("{}\u5373\u5c06\u5173\u95ed\u670d\u52a1\u5668\uff0c\u4e0d\u518d\u63a5\u53d7\u65b0\u8bf7\u6c42", (Object)aioServer.getServerNode());
            } else {
                AsynchronousServerSocketChannel serverSocketChannel = aioServer.getServerSocketChannel();
                serverSocketChannel.accept(aioServer, this);
            }
        }
    }

    @Override
    public void failed(Throwable exc, AioServer aioServer) {
        AsynchronousServerSocketChannel serverSocketChannel = aioServer.getServerSocketChannel();
        serverSocketChannel.accept(aioServer, this);
        log.error("[" + aioServer.getServerNode() + "]\u76d1\u542c\u51fa\u73b0\u5f02\u5e38", exc);
    }
}

