/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.udp.UdpClientConf;
import org.tio.core.udp.task.UdpSendRunnable;

public class UdpClient {
    private static Logger log = LoggerFactory.getLogger(UdpClient.class);
    private LinkedBlockingQueue<DatagramPacket> queue = new LinkedBlockingQueue();
    private UdpClientConf udpClientConf = null;
    private InetSocketAddress inetSocketAddress = null;
    private UdpSendRunnable udpSendRunnable = null;

    public static void main(String[] args) {
        UdpClientConf udpClientConf = new UdpClientConf("127.0.0.1", 3000, 5000);
        UdpClient udpClient = new UdpClient(udpClientConf);
        udpClient.start();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            String str = i + "\u3001\u6709\u70b9\u610f\u601d";
            udpClient.send(str.getBytes());
        }
        long end = System.currentTimeMillis();
        long iv = end - start;
        System.out.println("\u8017\u65f6:" + iv + "ms");
    }

    public UdpClient(UdpClientConf udpClientConf) {
        this.udpClientConf = udpClientConf;
        Node node = this.udpClientConf.getServerNode();
        this.inetSocketAddress = new InetSocketAddress(node.getIp(), node.getPort());
        this.udpSendRunnable = new UdpSendRunnable(this.queue, udpClientConf, null);
    }

    public void send(byte[] data) {
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, this.inetSocketAddress);
        this.queue.add(datagramPacket);
    }

    public void send(String str) {
        this.send(str, null);
    }

    public void send(String data, String charset) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        try {
            if (StringUtils.isBlank((CharSequence)charset)) {
                charset = this.udpClientConf.getCharset();
            }
            byte[] bs = data.getBytes(charset);
            this.send(bs);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void start() {
        Thread thread = new Thread((Runnable)this.udpSendRunnable, "tio-udp-client-send");
        thread.setDaemon(false);
        thread.start();
    }
}

