/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslUtils;
import org.tio.core.ssl.SslVo;
import org.tio.core.utils.AioUtils;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class SendRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(SendRunnable.class);
    private ConcurrentLinkedQueue<Packet> forSendAfterSslHandshakeCompleted = null;
    private ChannelContext channelContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentLinkedQueue<Packet> getForSendAfterSslHandshakeCompleted(boolean forceCreate) {
        if (forceCreate && this.forSendAfterSslHandshakeCompleted == null) {
            SendRunnable sendRunnable = this;
            synchronized (sendRunnable) {
                if (this.forSendAfterSslHandshakeCompleted == null) {
                    this.forSendAfterSslHandshakeCompleted = new ConcurrentLinkedQueue();
                }
            }
        }
        return this.forSendAfterSslHandshakeCompleted;
    }

    public SendRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
    }

    public boolean addMsg(Packet obj) {
        if (this.isCanceled()) {
            log.error("{}, \u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88\uff0c{}\u6dfb\u52a0\u5230\u53d1\u9001\u961f\u5217\u5931\u8d25", (Object)this.channelContext, (Object)obj);
            return false;
        }
        SslFacadeContext sslFacadeContext = this.channelContext.getSslFacadeContext();
        if (sslFacadeContext != null && !sslFacadeContext.isHandshakeCompleted() && SslUtils.needSslEncrypt(obj, this.channelContext)) {
            return this.getForSendAfterSslHandshakeCompleted(true).add(obj);
        }
        return this.msgQueue.add(obj);
    }

    public void clearMsgQueue() {
        Packet p = null;
        this.forSendAfterSslHandshakeCompleted = null;
        while ((p = (Packet)this.msgQueue.poll()) != null) {
            try {
                this.channelContext.processAfterSent(p, false);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    private ByteBuffer getByteBuffer(Packet packet, GroupContext groupContext, AioHandler aioHandler) {
        ByteBuffer byteBuffer = packet.getPreEncodedByteBuffer();
        if (byteBuffer == null) {
            byteBuffer = aioHandler.encode(packet, groupContext, this.channelContext);
        }
        if (byteBuffer.position() != 0) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    private static boolean swithed(Boolean oldValue, boolean newValue) {
        if (oldValue == null) {
            return false;
        }
        return !Objects.equals(oldValue, newValue);
    }

    public void runTask() {
        int queueSize = this.msgQueue.size();
        if (queueSize == 0) {
            return;
        }
        int listInitialCapacity = Math.min(queueSize, 200);
        GroupContext groupContext = this.channelContext.getGroupContext();
        AioHandler aioHandler = groupContext.getAioHandler();
        boolean isSsl = SslUtils.isSsl(this.channelContext);
        SslFacadeContext sslFacadeContext = this.channelContext.getSslFacadeContext();
        int maxCapacity = 102400;
        if (isSsl) {
            maxCapacity = 8192;
        }
        Packet packet = null;
        ArrayList<Packet> packets = new ArrayList<Packet>(listInitialCapacity);
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(listInitialCapacity);
        int packetCount = 0;
        int allBytebufferCapacity = 0;
        Boolean needSslEncrypted = null;
        boolean sslSwitched = false;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            ByteBuffer byteBuffer = this.getByteBuffer(packet, groupContext, aioHandler);
            packets.add(packet);
            byteBuffers.add(byteBuffer);
            ++packetCount;
            allBytebufferCapacity += byteBuffer.limit();
            if (isSsl) {
                boolean _needSslEncrypted;
                if (packet.isSslEncrypted()) {
                    _needSslEncrypted = false;
                    sslSwitched = SendRunnable.swithed(needSslEncrypted, _needSslEncrypted);
                    needSslEncrypted = _needSslEncrypted;
                } else {
                    _needSslEncrypted = true;
                    sslSwitched = SendRunnable.swithed(needSslEncrypted, _needSslEncrypted);
                    needSslEncrypted = _needSslEncrypted;
                }
            } else {
                needSslEncrypted = false;
            }
            if (allBytebufferCapacity < maxCapacity && !sslSwitched) continue;
            break;
        }
        ByteBuffer allByteBuffer = ByteBuffer.allocate(allBytebufferCapacity);
        for (ByteBuffer byteBuffer : byteBuffers) {
            allByteBuffer.put(byteBuffer);
        }
        allByteBuffer.flip();
        if (needSslEncrypted.booleanValue()) {
            SslVo sslVo = new SslVo(allByteBuffer, packets);
            try {
                sslFacadeContext.getSslFacade().encrypt(sslVo);
                allByteBuffer = sslVo.getByteBuffer();
            }
            catch (SSLException e) {
                log.error(this.channelContext.toString() + ", \u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Aio.close(this.channelContext, "\u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38");
                return;
            }
        }
        this.sendByteBuffer(allByteBuffer, packetCount, packets);
    }

    public void sendByteBuffer(ByteBuffer byteBuffer, Integer packetCount, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", (Object)this.channelContext);
            return;
        }
        if (!AioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        if (byteBuffer.position() != 0) {
            byteBuffer.flip();
        }
        AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
        WriteCompletionHandler writeCompletionHandler = this.channelContext.getWriteCompletionHandler();
        try {
            writeCompletionHandler.getWriteSemaphore().acquire();
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        WriteCompletionHandler.WriteCompletionVo writeCompletionVo = new WriteCompletionHandler.WriteCompletionVo(byteBuffer, packets);
        asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, writeCompletionHandler);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }
}

