/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import com.google.common.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.cache.IpStatRemovalListener;
import org.tio.core.intf.IpStatListener;
import org.tio.core.stat.IpStat;
import org.tio.utils.cache.guava.GuavaCache;

public class IpStats {
    private static Logger log = LoggerFactory.getLogger(IpStats.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String groupContextId;
    private GroupContext groupContext;
    public final Map<Long, GuavaCache> cacheMap = new HashMap<Long, GuavaCache>();
    public final List<Long> durationList = new ArrayList<Long>();

    public IpStats(GroupContext groupContext, IpStatListener ipStatListener, Long[] durations) {
        this.groupContext = groupContext;
        this.groupContextId = groupContext.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipStatListener);
            }
        }
    }

    public void addDuration(Long duration, IpStatListener ipStatListener) {
        GuavaCache guavaCache = GuavaCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new IpStatRemovalListener(this.groupContext, ipStatListener));
        this.cacheMap.put(duration, guavaCache);
        this.durationList.add(duration);
    }

    public void addDurations(Long[] durations, IpStatListener ipStatListener) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipStatListener);
            }
        }
    }

    public void removeDuration(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_STAT_" + this.groupContextId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return;
        }
        guavaCache.clear();
    }

    public IpStat get(Long duration, String ip) {
        return this.get(duration, ip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat get(Long duration, String ip, boolean forceCreate) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        IpStat ipStat = (IpStat)guavaCache.get(ip);
        if (ipStat == null && forceCreate) {
            IpStats ipStats = this;
            synchronized (ipStats) {
                ipStat = (IpStat)guavaCache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip, duration);
                    guavaCache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        ConcurrentMap map = guavaCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        return guavaCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        Collection<Serializable> set = guavaCache.asMap().values();
        return set;
    }
}

