/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.utils.lock.ObjWithLock;

public class ClientNodeMap {
    private ObjWithLock<DualHashBidiMap<String, ChannelContext>> map = new ObjWithLock((Object)new DualHashBidiMap());

    public static String getKey(ChannelContext channelContext) {
        Node clientNode = channelContext.getClientNode();
        if (clientNode == null) {
            throw new RuntimeException("client node is null");
        }
        String key = ClientNodeMap.getKey(clientNode.getIp(), clientNode.getPort());
        return key;
    }

    public static String getKey(String ip, int port) {
        String key = ip + ":" + port;
        return key;
    }

    public ChannelContext find(String key) {
        ReentrantReadWriteLock.ReadLock lock = this.map.getLock().readLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)((Object)m.get((Object)key));
            return channelContext;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(String ip, int port) {
        String key = ClientNodeMap.getKey(ip, port);
        return this.find(key);
    }

    public ObjWithLock<DualHashBidiMap<String, ChannelContext>> getMap() {
        return this.map;
    }

    public void put(ChannelContext channelContext) {
        String key = ClientNodeMap.getKey(channelContext);
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            m.put((Object)key, (Object)channelContext);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public void remove(ChannelContext channelContext) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap m = (DualHashBidiMap)this.map.getObj();
        try {
            lock.lock();
            m.removeValue((Object)channelContext);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

