/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cache;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.intf.IpStatListener;
import org.tio.core.stat.IpStat;

public class IpStatRemovalListener
implements RemovalListener {
    private static Logger log = LoggerFactory.getLogger(IpStatRemovalListener.class);
    private IpStatListener ipStatListener;
    private GroupContext groupContext = null;

    public IpStatRemovalListener(GroupContext groupContext, IpStatListener ipStatListener) {
        this.groupContext = groupContext;
        this.ipStatListener = ipStatListener;
    }

    public static void main(String[] args) {
    }

    public void onRemoval(RemovalNotification notification) {
        String ip = (String)notification.getKey();
        IpStat ipStat = (IpStat)notification.getValue();
        if (this.ipStatListener != null) {
            this.ipStatListener.onExpired(this.groupContext, ipStat);
        }
    }
}

