/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.AioClient;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.ssl.SslUtils;
import org.tio.utils.SystemTimer;

public class ConnectionCompletionHandler
implements CompletionHandler<Void, ConnectionCompletionVo> {
    private static Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    @Override
    public void completed(Void result, ConnectionCompletionVo attachment) {
        this.handler(result, attachment, null);
    }

    @Override
    public void failed(Throwable throwable, ConnectionCompletionVo attachment) {
        this.handler(null, attachment, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handler(Void result, ConnectionCompletionVo attachment, Throwable throwable) {
        ClientChannelContext channelContext = attachment.getChannelContext();
        AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
        AioClient aioClient = attachment.getAioClient();
        ClientGroupContext clientGroupContext = aioClient.getClientGroupContext();
        Node serverNode = attachment.getServerNode();
        String bindIp = attachment.getBindIp();
        Integer bindPort = attachment.getBindPort();
        ClientAioListener clientAioListener = clientGroupContext.getClientAioListener();
        boolean isReconnect = attachment.isReconnect();
        boolean isConnected = false;
        try {
            if (throwable == null) {
                if (isReconnect) {
                    channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                    channelContext.getHandlerRunnable().setCanceled(false);
                    channelContext.getSendRunnable().setCanceled(false);
                    clientGroupContext.closeds.remove(channelContext);
                } else {
                    channelContext = new ClientChannelContext(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                channelContext.setBindIp(bindIp);
                channelContext.setBindPort(bindPort);
                channelContext.setReconnCount(0);
                channelContext.setClosed(false);
                isConnected = true;
                attachment.setChannelContext(channelContext);
                clientGroupContext.connecteds.add(channelContext);
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                log.info("connected to {}", (Object)serverNode);
                if (isConnected && !isReconnect) {
                    channelContext.getStat().setTimeFirstConnected(SystemTimer.currentTimeMillis());
                }
            } else {
                log.error(throwable.toString(), throwable);
                if (channelContext == null) {
                    channelContext = new ClientChannelContext(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                if (!isReconnect) {
                    clientGroupContext.closeds.add(channelContext);
                }
                attachment.setChannelContext(channelContext);
                ReconnConf.put(channelContext);
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            if (attachment.getCountDownLatch() != null) {
                attachment.getCountDownLatch().countDown();
            }
            try {
                channelContext.setReconnect(isReconnect);
                if (SslUtils.isSsl(channelContext)) {
                    if (isConnected) {
                        channelContext.getSslFacadeContext().beginHandshake();
                    } else {
                        clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                } else {
                    clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                }
            }
            catch (Throwable e1) {
                log.error(e1.toString(), e1);
            }
        }
    }
}

