package org.tio.core.stat;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import org.tio.utils.SystemTimer;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.BetweenFormater.Level;

/**
 * 这个是给服务器用的，主要用于监控IP情况，随时拉黑恶意攻击IP
 * @author tanyaowu
 * 2017年8月20日 下午8:02:41
 */
public class IpStat implements java.io.Serializable {

	private static final long serialVersionUID = -6942731710053482089L;

	private Date start = new Date();

	/**
	 * 当前统计了多久，单位：毫秒
	 */
	private long duration;

	/**
	 * 时长类型，单位：秒，譬如60，3600等
	 */
	private Long durationType;

	/**
	 * 客户端ip
	 */
	private String ip;

	/**
	 * 解码异常的次数
	 */
	private AtomicInteger decodeErrorCount = new AtomicInteger();

	/**
	 * 收到该IP连接请求的次数
	 */
	private AtomicInteger requestCount = new AtomicInteger();

	/**
	 * 当前处于连接状态的个数
	 */
//	private static MapWithLock<String, AtomicInteger> activatedCount = new MapWithLock<>(new HashMap<String, AtomicInteger>());

	/**
	 * 本IP已发送的字节数
	 */
	private AtomicLong sentBytes = new AtomicLong();

	/**
	 * 本IP已发送的packet数
	 */
	private AtomicLong sentPackets = new AtomicLong();

	/**
	 * 本IP已处理的字节数
	 */
	private AtomicLong handledBytes = new AtomicLong();

	/**
	 * 本IP已处理的packet数
	 */
	private AtomicLong handledPackets = new AtomicLong();

	/**
	 * 本IP已接收的字节数
	 */
	private AtomicLong receivedBytes = new AtomicLong();

	/**
	 * 本IP已接收了多少次TCP数据包
	 */
	private AtomicLong receivedTcps = new AtomicLong();

	/**
	 * 本IP已接收的packet数
	 */
	private AtomicLong receivedPackets = new AtomicLong();

	public IpStat(String ip, Long durationType) {
		this.ip = ip;
		this.durationType = durationType;
	}

//	/**
//	 * @return the activatedCount
//	 */
//	public static AtomicInteger getActivatedCount(String ip, boolean forceCreate) {
//		AtomicInteger atomicInteger = activatedCount.getObj().get(ip);
//		if (atomicInteger == null && forceCreate) {
//			Lock lock = activatedCount.getLock().writeLock();
//			try {
//				lock.lock();
//				atomicInteger = activatedCount.getObj().get(ip);
//				if (atomicInteger == null) {
//					atomicInteger = new AtomicInteger();
//					activatedCount.getObj().put(ip, atomicInteger);
//				}
//			} catch (Throwable e) {
//				throw e;
//			} finally {
//				lock.unlock();
//			}
//		}
//		return atomicInteger;
//	}
//	
//	public static void removeActivatedCount(String ip) {
//		Lock lock = activatedCount.getLock().writeLock();
//		try {
//			lock.lock();
//			activatedCount.getObj().remove(ip);
//		} catch (Throwable e) {
//			throw e;
//		} finally {
//			lock.unlock();
//		}
//	}

	/**
	 * 平均每次TCP接收到的字节数，这个可以用来监控慢攻击，配置PacketsPerTcpReceive定位慢攻击
	 */
	public double getBytesPerTcpReceive() {
		if (receivedTcps.get() == 0) {
			return 0;
		}
		double ret = (double) receivedBytes.get() / (double) receivedTcps.get();
		return ret;
	}

	/**
	 * @return the decodeErrorCount
	 */
	public AtomicInteger getDecodeErrorCount() {
		return decodeErrorCount;
	}

	public long getDuration() {
		duration = SystemTimer.currentTimeMillis() - this.start.getTime();
		return duration;
	}

	/**
	 * @return the durationType
	 */
	public Long getDurationType() {
		return durationType;
	}

	/**
	 * @return the duration
	 */
	public String getFormatedDuration() {
		duration = SystemTimer.currentTimeMillis() - this.start.getTime();
		BetweenFormater betweenFormater = new BetweenFormater(duration, Level.MILLSECOND);
		return betweenFormater.format();
	}

	/**
	 * @return the countHandledByte
	 */
	public AtomicLong getHandledBytes() {
		return handledBytes;
	}

	/**
	 * @return the countHandledPacket
	 */
	public AtomicLong getHandledPackets() {
		return handledPackets;
	}

	/**
	 * @return the ip
	 */
	public String getIp() {
		return ip;
	}

	/**
	 * 平均每次TCP接收到的业务包数，这个可以用来监控慢攻击，此值越小越有攻击嫌疑
	 */
	public double getPacketsPerTcpReceive() {
		if (receivedTcps.get() == 0) {
			return 0;
		}
		double ret = (double) receivedPackets.get() / (double) receivedTcps.get();
		return ret;
	}

	/**
	 * @return the countReceivedByte
	 */
	public AtomicLong getReceivedBytes() {
		return receivedBytes;
	}

	/**
	 * @return the countReceivedPacket
	 */
	public AtomicLong getReceivedPackets() {
		return receivedPackets;
	}

	/**
	 * @return the receivedTcps
	 */
	public AtomicLong getReceivedTcps() {
		return receivedTcps;
	}

	/**
	 * @return the requestCount
	 */
	public AtomicInteger getRequestCount() {
		return requestCount;
	}

	/**
	 * @return the countSentByte
	 */
	public AtomicLong getSentBytes() {
		return sentBytes;
	}

	/**
	 * @return the countSentPacket
	 */
	public AtomicLong getSentPackets() {
		return sentPackets;
	}

	/**
	 * @return the start
	 */
	public Date getStart() {
		return start;
	}

	/**
	 * @param durationType the durationType to set
	 */
	public void setDurationType(Long durationType) {
		this.durationType = durationType;
	}

	/**
	 * @param ip the ip to set
	 */
	public void setIp(String ip) {
		this.ip = ip;
	}

	/**
	 * @param start the start to set
	 */
	public void setStart(Date start) {
		this.start = start;
	}
}
