/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.method.InvalidMethodKeyException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MethodKey
implements Serializable {
    private Class declaredType;
    private String methodName;
    private Class[] parameterTypes;
    private transient Method method;
    private static final Map primitiveWrapperTypeMap = new HashMap(8);

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
    }

    public MethodKey(Class declaredType, String methodName, Class[] parameterTypes) {
        Assert.notNull((Object)declaredType, (String)"The method's declared type is required");
        Assert.notNull((Object)methodName, (String)"The method name is required");
        this.declaredType = declaredType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class getDeclaredType() {
        return this.declaredType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodKeyException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodKeyException {
        try {
            return this.declaredType.getMethod(this.methodName, this.parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodKeyException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods = this.getDeclaredType().getMethods();
        int i = 0;
        while (i < candidateMethods.length) {
            Class<?>[] candidateParameterTypes;
            if (candidateMethods[i].getName().equals(this.methodName) && (candidateParameterTypes = candidateMethods[i].getParameterTypes()).length == this.parameterTypes.length) {
                int numberOfCorrectArguments = 0;
                int j = 0;
                while (j < candidateParameterTypes.length) {
                    Class<?> candidateType = candidateParameterTypes[j];
                    Class parameterType = this.parameterTypes[j];
                    if (parameterType != null) {
                        if (MethodKey.isAssignable(candidateType, parameterType)) {
                            ++numberOfCorrectArguments;
                        }
                    } else {
                        ++numberOfCorrectArguments;
                    }
                    ++j;
                }
                if (numberOfCorrectArguments == this.parameterTypes.length) {
                    return candidateMethods[i];
                }
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)obj;
        return this.declaredType.equals(other.declaredType) && this.methodName.equals(other.methodName) && this.parameterTypesEqual(other.parameterTypes);
    }

    private boolean parameterTypesEqual(Class[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (!ObjectUtils.nullSafeEquals((Object)this.parameterTypes[i], (Object)other[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.declaredType.hashCode() + this.methodName.hashCode() + this.parameterTypesHash();
    }

    private int parameterTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        int i = 0;
        while (i < this.parameterTypes.length) {
            Class parameterType = this.parameterTypes[i];
            if (parameterType != null) {
                hash += this.parameterTypes[i].hashCode();
            }
            ++i;
        }
        return hash;
    }

    public String toString() {
        return String.valueOf(this.methodName) + "(" + this.parameterTypesString() + ")";
    }

    private String parameterTypesString() {
        StringBuffer parameterTypesString = new StringBuffer();
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (this.parameterTypes[i] == null) {
                parameterTypesString.append("<any>");
            } else {
                parameterTypesString.append(ClassUtils.getShortName((Class)this.parameterTypes[i]));
            }
            if (i < this.parameterTypes.length - 1) {
                parameterTypesString.append(',');
            }
            ++i;
        }
        return parameterTypesString.toString();
    }

    private static boolean isAssignable(Class targetType, Class valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }
}

