/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.AnyTypePattern;
import org.springsource.loaded.ChildClassLoader;
import org.springsource.loaded.ExactTypePattern;
import org.springsource.loaded.ExecutorBuilder;
import org.springsource.loaded.FileChangeListener;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.IncrementalTypeDescriptor;
import org.springsource.loaded.IsReloadableTypePlugin;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.NameRegistry;
import org.springsource.loaded.Plugin;
import org.springsource.loaded.PrefixTypePattern;
import org.springsource.loaded.ReloadEventProcessorPlugin;
import org.springsource.loaded.ReloadException;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDelta;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeDescriptorExtractor;
import org.springsource.loaded.TypePattern;
import org.springsource.loaded.UnableToReloadEventProcessorPlugin;
import org.springsource.loaded.Utils;
import org.springsource.loaded.__DynamicallyDispatchable;
import org.springsource.loaded.agent.FileSystemWatcher;
import org.springsource.loaded.agent.ReloadDecision;
import org.springsource.loaded.agent.ReloadableFileChangeListener;
import org.springsource.loaded.agent.SpringLoadedPreProcessor;
import org.springsource.loaded.infra.UsedByGeneratedCode;
import org.springsource.loaded.support.Java8;
import sl.org.objectweb.asm.Handle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeRegistry {
    private static final String[][] ignorablePackagePrefixes;
    private static Logger log;
    public static boolean nothingReloaded;
    private static final String[] STANDARD_EXCLUDED_LOADERS;
    public static final String Key_ExcludedLoaders = "excluded.loaders";
    public static final String Key_Inclusions = "inclusions";
    public static final String Key_Exclusions = "exclusions";
    public static final String Key_ReloadableRebase = "rebasePaths";
    public static final String Key_Profile = "profile";
    public static int nextFreeRegistryId;
    private int maxClassDefinitions;
    private static Map<ClassLoader, TypeRegistry> loaderToRegistryMap;
    private static String[] excludedLoaders;
    private Map<String, String> rebasePaths = new HashMap<String, String>();
    private List<String> pluginClassNames = new ArrayList<String>();
    List<Plugin> localPlugins = new ArrayList<Plugin>();
    public boolean directlyDefineTypes = true;
    private WeakReference<ClassLoader> classLoader;
    private int id;
    TypeDescriptorExtractor extractor;
    ExecutorBuilder executorBuilder;
    private boolean configured = false;
    private Properties configuration;
    private List<TypePattern> inclusionPatterns = null;
    private List<TypePattern> exclusionPatterns = null;
    Map<String, TypeDescriptor> reloadableTypeDescriptorCache = new HashMap<String, TypeDescriptor>();
    Map<String, TypeDescriptor> typeDescriptorCache = new HashMap<String, TypeDescriptor>();
    Map<String, ReloadableType> cglibProxies = new HashMap<String, ReloadableType>();
    Map<String, ReloadableType> cglibProxiesFastClass = new HashMap<String, ReloadableType>();
    public Map<String, Set<ReloadableType>> jdkProxiesForInterface = new HashMap<String, Set<ReloadableType>>();
    private static List<String> excludedLoaderInstances;
    private static Method getResourceMethod;
    private List<String> packagesFound = new ArrayList<String>();
    private List<String> packagesNotFound = new ArrayList<String>();
    private static WeakReference<TypeRegistry>[] registryInstances;
    private WeakReference<ChildClassLoader> childClassLoader;
    private ReloadableType[] reloadableTypes = new ReloadableType[10];
    private int reloadableTypesSize = 0;
    private Method defineClassMethod = null;
    private FileChangeListener fileChangeListener;
    private FileSystemWatcher fsWatcher;
    private Set<String> watching = new HashSet<String>();
    private Class<?> class_GroovySystem;
    private Class<?> class_ClassInfo;
    private Method method_ClassInfo_getClassInfo;
    private Field field_ClassInfo_cachedClassRef;
    private long lastTidyup = 0L;
    private static Map<String, BsmInfo[]> bsmmap;

    public static void reinitialize() {
        nextFreeRegistryId = 0;
        loaderToRegistryMap.clear();
        registryInstances = new WeakReference[10];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeRegistry(ClassLoader classloader) {
        this.directlyDefineTypes = GlobalConfiguration.directlyDefineTypes;
        this.classLoader = new WeakReference<ClassLoader>(classloader);
        this.maxClassDefinitions = GlobalConfiguration.maxClassDefinitions;
        Class<TypeRegistry> clazz = TypeRegistry.class;
        synchronized (TypeRegistry.class) {
            this.id = nextFreeRegistryId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.id >= registryInstances.length) {
                WeakReference[] newRegistryInstances = new WeakReference[registryInstances.length + 10];
                System.arraycopy(registryInstances, 0, newRegistryInstances, 0, registryInstances.length);
                registryInstances = newRegistryInstances;
            }
            TypeRegistry.registryInstances[this.id] = new WeakReference<TypeRegistry>(this);
            loaderToRegistryMap.put(classloader, this);
            this.extractor = new TypeDescriptorExtractor(this);
            this.executorBuilder = new ExecutorBuilder(this);
            this.ensureConfigured();
            return;
        }
    }

    public static boolean typeRegistryExistsForId(int typeRegistryId) {
        for (TypeRegistry typeRegistry : loaderToRegistryMap.values()) {
            if (typeRegistry == null || typeRegistry.getId() != typeRegistryId) continue;
            return true;
        }
        return false;
    }

    public static TypeRegistry getTypeRegistryFor(ClassLoader classloader) {
        if (classloader == null) {
            return null;
        }
        TypeRegistry existingRegistry = loaderToRegistryMap.get(classloader);
        if (existingRegistry != null) {
            return existingRegistry;
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO) && excludedLoaderInstances.contains(classloader.toString())) {
            return null;
        }
        String classloaderName = classloader.getClass().getName();
        if (classloaderName.equals("sun.reflect.DelegatingClassLoader")) {
            return null;
        }
        for (String excluded : excludedLoaders) {
            if (!classloaderName.startsWith(excluded)) continue;
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                log.info("Classloader " + classloaderName + " has been deliberately excluded");
            }
            excludedLoaderInstances.add(classloader.toString());
            return null;
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("TypeRegistry.getRegistryFor(): creating new TypeRegistry for loader " + classloader);
        }
        TypeRegistry tr = new TypeRegistry(classloader);
        return tr;
    }

    public TypeDescriptor getDescriptorForReloadableType(String slashedClassname) {
        return this.reloadableTypeDescriptorCache.get(slashedClassname);
    }

    public TypeDescriptor getDescriptorFor(String slashedname) {
        TypeDescriptor cached = this.checkCache(slashedname);
        if (cached != null) {
            return cached;
        }
        byte[] data = Utils.loadSlashedClassAsBytes((ClassLoader)this.classLoader.get(), slashedname);
        boolean isReloadableType = this.isReloadableTypeName(slashedname);
        TypeDescriptor td = this.extractor.extract(data, isReloadableType);
        if (isReloadableType) {
            this.reloadableTypeDescriptorCache.put(slashedname, td);
        } else {
            this.typeDescriptorCache.put(slashedname, td);
        }
        return td;
    }

    public TypeDescriptor getLatestDescriptorFor(String slashedname) {
        TypeDescriptor cached = this.checkCache(slashedname);
        if (cached != null) {
            return cached;
        }
        byte[] data = Utils.loadSlashedClassAsBytes((ClassLoader)this.classLoader.get(), slashedname);
        boolean isReloadableType = this.isReloadableTypeName(slashedname);
        TypeDescriptor td = this.extractor.extract(data, isReloadableType);
        if (isReloadableType) {
            this.reloadableTypeDescriptorCache.put(slashedname, td);
        } else {
            this.typeDescriptorCache.put(slashedname, td);
        }
        return td;
    }

    private TypeDescriptor checkCache(String slashedname) {
        TypeDescriptor td = this.typeDescriptorCache.get(slashedname);
        if (td == null) {
            td = this.reloadableTypeDescriptorCache.get(slashedname);
        }
        return td;
    }

    public void ensureConfigured() {
        if (this.configured) {
            return;
        }
        this.loadPropertiesConfiguration();
        this.processPropertiesConfiguration();
        this.loadPlugins();
        this.configured = true;
    }

    private void loadPlugins() {
        try {
            Enumeration<URL> pluginResources = ((ClassLoader)this.classLoader.get()).getResources("META-INF/services/org.springsource.reloading.agent.Plugins");
            while (pluginResources.hasMoreElements()) {
                URL pluginResource = pluginResources.nextElement();
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                    log.finest("loadPlugins: TypeRegistry=" + this.toString() + ": loading plugin list file " + pluginResource);
                }
                InputStream is = pluginResource.openStream();
                BufferedReader pluginClassNamesReader = new BufferedReader(new InputStreamReader(is));
                try {
                    String pluginName;
                    while ((pluginName = pluginClassNamesReader.readLine()) != null) {
                        if (pluginName.startsWith("#")) continue;
                        this.pluginClassNames.add(pluginName);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String pluginClassName : this.pluginClassNames) {
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                log.finest("loadPlugins: TypeRegistry=" + this.toString() + ": loading plugin " + pluginClassName);
            }
            try {
                Class<?> pluginClass = Class.forName(pluginClassName, false, (ClassLoader)this.classLoader.get());
                Plugin pluginInstance = (Plugin)pluginClass.newInstance();
                this.localPlugins.add(pluginInstance);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to find and instantiate plugin " + pluginClassName, e);
            }
        }
    }

    public void configure(Properties properties) {
        this.resetConfiguration();
        this.configuration = properties;
        this.processPropertiesConfiguration();
        this.configured = true;
    }

    public void resetConfiguration() {
        this.inclusionPatterns = null;
        nothingReloaded = true;
    }

    public static void resetAllConfiguration() {
        nothingReloaded = true;
    }

    public List<TypePattern> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public List<TypePattern> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    private void processPropertiesConfiguration() {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
            log.finest("processPropertiesConfiguration: TypeRegistry=" + this.toString());
        }
        this.inclusionPatterns = this.getPatternsFrom(this.configuration.getProperty(Key_Inclusions));
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
            log.finest("processPropertiesConfiguration: inclusions are set to '" + this.inclusionPatterns + "'");
        }
        this.exclusionPatterns = this.getPatternsFrom(this.configuration.getProperty(Key_Exclusions));
        String value = this.configuration.getProperty(Key_ReloadableRebase);
        if (value != null) {
            this.parseRebasePaths(value);
        }
        if ((value = this.configuration.getProperty(Key_ExcludedLoaders)) != null && !value.equals("NONE")) {
            ArrayList<String> loaders = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreElements()) {
                String loaderPrefix = st.nextToken();
                if (loaderPrefix.toLowerCase().equals("default")) {
                    for (String element : STANDARD_EXCLUDED_LOADERS) {
                        loaders.add(element);
                    }
                    continue;
                }
                loaders.add(loaderPrefix);
            }
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.log(Level.FINER, "Setting exclusions to " + loaders);
            }
            excludedLoaders = loaders.toArray(new String[0]);
        }
    }

    private void parseRebasePaths(String rebaseDefinitions) {
        StringTokenizer tokenizer = new StringTokenizer(rebaseDefinitions, ",");
        while (tokenizer.hasMoreTokens()) {
            String rebasePair = tokenizer.nextToken();
            int equals = rebasePair.indexOf(61);
            String fromPrefix = rebasePair.substring(0, equals);
            String toPrefix = rebasePair.substring(equals + 1);
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("processPropertiesConfiguration: adding rebase rule from '" + fromPrefix + "' to '" + toPrefix + "'");
            }
            this.rebasePaths.put(fromPrefix, toPrefix);
        }
    }

    private void loadPropertiesConfiguration() {
        this.configuration = new Properties(GlobalConfiguration.globalConfigurationProperties);
        try {
            Enumeration<URL> resources;
            HashSet<String> configurationFiles = new HashSet<String>();
            ClassLoader classloader = (ClassLoader)this.classLoader.get();
            Enumeration<URL> enumeration = resources = classloader == null ? null : classloader.getResources("springloaded.properties");
            if (resources == null) {
                if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                    log.info("Unable to load springloaded.properties, cannot find it through classloader " + classloader);
                }
            } else {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    String configFile = url.toString();
                    if (GlobalConfiguration.logging && log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, this.toString() + ": processing config file: " + url.toString());
                    }
                    if (configurationFiles.contains(configFile)) continue;
                    configurationFiles.add(configFile);
                    InputStream is = url.openStream();
                    Properties p = new Properties();
                    p.load(is);
                    is.close();
                    Set<String> keys = p.stringPropertyNames();
                    for (String key : keys) {
                        if (!this.configuration.containsKey(key)) {
                            this.configuration.put(key, p.getProperty(key));
                            continue;
                        }
                        String valueSoFar = this.configuration.getProperty(key);
                        StringBuilder sb = new StringBuilder(valueSoFar);
                        sb.append(",");
                        sb.append(p.getProperty(key));
                        this.configuration.put(key, sb.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ReloadException("loadPropertiesConfiguration: Problem accessing springloaded.properties file resources", e);
        }
    }

    private boolean couldBeReloadable(String slashedName) {
        int lastSlashPos;
        String packageName;
        String[] candidates;
        if (slashedName == null) {
            return false;
        }
        if (slashedName.startsWith("java/")) {
            return false;
        }
        char ch = slashedName.charAt(0);
        int index = ch - 97;
        if (index > 0 && index < 26 && (candidates = ignorablePackagePrefixes[index]) != null) {
            for (String ignorablePackagePrefix : candidates) {
                if (!slashedName.startsWith(ignorablePackagePrefix)) continue;
                if (GlobalConfiguration.explainMode && log.isLoggable(Level.INFO)) {
                    log.info("WhyNotReloadable? The type " + slashedName + " is using a package name '" + ignorablePackagePrefix + "' which is considered infrastructure and types within it are not made reloadable");
                }
                return false;
            }
        }
        if (slashedName.indexOf("$Proxy") != -1 || slashedName.indexOf("$$EnhancerBy") != -1 || slashedName.indexOf("$$FastClassBy") != -1) {
            return true;
        }
        int underscorePos = slashedName.indexOf("_");
        if (underscorePos != -1) {
            if (slashedName.endsWith("_jspx") || slashedName.endsWith("_tagx")) {
                return false;
            }
            if (slashedName.endsWith("_jspx$Helper") || slashedName.endsWith("_tagx$Helper")) {
                return false;
            }
            if (ch == '_' && slashedName.indexOf("_groovy") != -1) {
                return false;
            }
        }
        String string = packageName = (lastSlashPos = slashedName.lastIndexOf(47)) == -1 ? null : slashedName.substring(0, lastSlashPos);
        if (packageName != null) {
            for (String foundPackageName : this.packagesFound) {
                if (!packageName.equals(foundPackageName)) continue;
                return true;
            }
            for (String notfoundPackageName : this.packagesNotFound) {
                if (!packageName.equals(notfoundPackageName)) continue;
                return false;
            }
        }
        if (ch == '[') {
            return false;
        }
        try {
            if (getResourceMethod == null) {
                try {
                    getResourceMethod = ClassLoader.class.getDeclaredMethod("getResource", String.class);
                }
                catch (Exception e) {
                    throw new ReloadException("Unable to locate 'getResource' on the ClassLoader class", e);
                }
            }
            getResourceMethod.setAccessible(true);
            URL url = (URL)getResourceMethod.invoke(this.classLoader.get(), slashedName + ".class");
            boolean reloadable = false;
            if (url != null) {
                String protocol = url.getProtocol();
                reloadable = protocol.equals("file");
            }
            if (packageName != null) {
                if (reloadable) {
                    this.packagesFound.add(packageName);
                } else {
                    this.packagesNotFound.add(packageName);
                }
            }
            return reloadable;
        }
        catch (Exception e) {
            throw new ReloadException("Unexpected problem locating the bytecode for " + slashedName + ".class", e);
        }
    }

    public boolean isReloadableTypeName(String slashedName) {
        return this.isReloadableTypeName(slashedName, null, null);
    }

    public boolean isReloadableTypeName(String slashedName, ProtectionDomain protectionDomain, byte[] bytes) {
        String matchName;
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.FINER)) {
            log.finer("entering TypeRegistry.isReloadableTypeName(" + slashedName + ")");
        }
        if (GlobalConfiguration.assertsMode) {
            Utils.assertSlashed(slashedName);
        }
        for (IsReloadableTypePlugin plugin : SpringLoadedPreProcessor.getIsReloadableTypePlugins()) {
            Object decision = plugin.shouldBeMadeReloadable(this, slashedName, protectionDomain, bytes);
            if (decision == ReloadDecision.YES) {
                if (GlobalConfiguration.explainMode && log.isLoggable(Level.FINER)) {
                    log.finer("[explanation] The plugin " + plugin.getClass().getName() + " determined type " + slashedName + " is reloadable");
                }
                return true;
            }
            if (decision != ReloadDecision.NO) continue;
            if (GlobalConfiguration.explainMode && log.isLoggable(Level.FINER)) {
                log.finer("[explanation] The plugin " + plugin.getClass().getName() + " determined type " + slashedName + " is not reloadable");
            }
            return false;
        }
        if (this.inclusionPatterns.isEmpty()) {
            if (this.exclusionPatterns.isEmpty()) {
                if (this.couldBeReloadable(slashedName)) {
                    if (GlobalConfiguration.explainMode && log.isLoggable(Level.FINER)) {
                        log.finer("[explanation] The class " + slashedName + " is currently considered reloadable. It matches no exclusions, is accessible from this classloader and is not in a jar/zip.");
                    }
                    return true;
                }
                if (GlobalConfiguration.explainMode && log.isLoggable(Level.FINER)) {
                    log.finer("[explanation] The class " + slashedName + " is not going to be treated as reloadable.");
                }
                return false;
            }
            boolean isExcluded = false;
            matchName = slashedName.replace('/', '.');
            for (TypePattern typepattern : this.exclusionPatterns) {
                if (!typepattern.matches(matchName)) continue;
                isExcluded = true;
                break;
            }
            if (isExcluded) {
                return false;
            }
            return this.couldBeReloadable(slashedName);
        }
        boolean isIncluded = false;
        matchName = slashedName.replace('/', '.');
        for (TypePattern typepattern : this.inclusionPatterns) {
            if (!typepattern.matches(matchName)) continue;
            isIncluded = true;
            break;
        }
        if (!isIncluded) {
            return false;
        }
        if (this.exclusionPatterns.isEmpty()) {
            return true;
        }
        boolean isExcluded = false;
        for (TypePattern typepattern : this.exclusionPatterns) {
            if (!typepattern.matches(matchName)) continue;
            isExcluded = true;
            break;
        }
        return !isExcluded;
    }

    public int getTypeIdFor(String slashname, boolean allocateIfNotFound) {
        if (allocateIfNotFound) {
            return NameRegistry.getIdOrAllocateFor(slashname);
        }
        return NameRegistry.getIdFor(slashname);
    }

    public byte[] methodCallRewrite(byte[] bytes) {
        return MethodInvokerRewriter.rewrite(this, bytes);
    }

    public byte[] methodCallRewriteUseCacheIfAvailable(String slashedClassName, byte[] bytes) {
        if (GlobalConfiguration.isCaching) {
            return MethodInvokerRewriter.rewriteUsingCache(slashedClassName, this, bytes);
        }
        return MethodInvokerRewriter.rewrite(this, bytes);
    }

    public void loadNewVersion(ReloadableType rtype, File file) {
        String versionstamp = Utils.encode(file.lastModified());
        byte[] newBytes = null;
        try {
            newBytes = Utils.loadFromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        rtype.loadNewVersion(versionstamp, newBytes);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public int getId() {
        return this.id;
    }

    public ReloadableType addType(String dottedname, byte[] initialbytes) {
        String[] interfacesImplemented;
        String originalType;
        TypeDescriptor td;
        if (GlobalConfiguration.logging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "ReloadableType.addType(): processing " + dottedname);
        }
        if ((td = this.extractor.extract(initialbytes, true)).isAnnotation()) {
            return null;
        }
        String slashname = dottedname.replace('.', '/');
        this.reloadableTypeDescriptorCache.put(slashname, td);
        if (GlobalConfiguration.assertsMode) {
            Utils.assertTrue(td.getName().equals(slashname), "Name from bytecode '" + td.getName() + "' does not match that passed in '" + slashname + "'");
        }
        int typeId = NameRegistry.getIdOrAllocateFor(slashname);
        ReloadableType rtype = new ReloadableType(dottedname, initialbytes, typeId, this, td);
        if (GlobalConfiguration.classesToDump != null && GlobalConfiguration.classesToDump.contains(slashname)) {
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("Dumping bytes for " + slashname);
            }
            Utils.dump(slashname, rtype.getBytesLoaded());
        }
        if (typeId >= this.reloadableTypes.length) {
            this.resizeReloadableTypeArray(typeId);
        }
        this.reloadableTypes[typeId] = rtype;
        if (typeId + 1 > this.reloadableTypesSize) {
            this.reloadableTypesSize = typeId + 1;
        }
        int cglibIndex = slashname.indexOf("$$EnhancerBy");
        int fcIndex = slashname.indexOf("$$FastClassBy");
        if (fcIndex != -1) {
            originalType = slashname.substring(0, fcIndex);
            this.cglibProxiesFastClass.put(originalType, rtype);
        } else if (cglibIndex != -1) {
            originalType = slashname.substring(0, cglibIndex);
            this.cglibProxies.put(originalType, rtype);
        }
        int jdkProxyIndex = slashname.indexOf("$Proxy");
        if ((jdkProxyIndex == 0 || jdkProxyIndex > 0 && slashname.charAt(jdkProxyIndex - 1) == '/') && (interfacesImplemented = Utils.discoverInterfaces(initialbytes)) != null) {
            for (int i = 0; i < interfacesImplemented.length; ++i) {
                Set<ReloadableType> l = this.jdkProxiesForInterface.get(interfacesImplemented[i]);
                if (l == null) {
                    l = new HashSet<ReloadableType>();
                    this.jdkProxiesForInterface.put(interfacesImplemented[i], l);
                }
                l.add(rtype);
            }
        }
        if (GlobalConfiguration.logging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "ReloadableType.addType(): Type '" + dottedname + "' is now reloadable! id=" + typeId);
        }
        return rtype;
    }

    private synchronized void resizeReloadableTypeArray(int typeId) {
        if (typeId < this.reloadableTypes.length) {
            return;
        }
        int extraSpace = typeId - this.reloadableTypes.length + 1;
        if (extraSpace < 10) {
            extraSpace = 10;
        }
        ReloadableType[] newReloadableTypes = new ReloadableType[this.reloadableTypes.length + extraSpace];
        System.arraycopy(this.reloadableTypes, 0, newReloadableTypes, 0, this.reloadableTypes.length);
        this.reloadableTypes = newReloadableTypes;
    }

    public ReloadableType getReloadableType(int typeId) {
        if (typeId >= this.reloadableTypesSize) {
            return null;
        }
        return this.reloadableTypes[typeId];
    }

    public void rememberReloadableType(int typeId, ReloadableType rtype) {
        if (typeId >= this.reloadableTypes.length) {
            this.resizeReloadableTypeArray(typeId);
        }
        this.reloadableTypes[typeId] = rtype;
        if (typeId + 1 > this.reloadableTypesSize) {
            this.reloadableTypesSize = typeId + 1;
        }
    }

    public ReloadableType getReloadableType(String slashedClassName) {
        int id = this.getTypeIdFor(slashedClassName, true);
        if (id >= this.reloadableTypesSize) {
            return null;
        }
        return this.getReloadableType(id);
    }

    public ReloadableType getReloadableSuperType(String slashedClassname) {
        ReloadableType rtype = this.getReloadableTypeInTypeRegistryHierarchy(slashedClassname);
        if (rtype != null) {
            return rtype;
        }
        return this.getReloadableType(slashedClassname);
    }

    private ReloadableType getReloadableTypeInTypeRegistryHierarchy(String classname) {
        ReloadableType rtype = this.getReloadableType(classname, false);
        if (rtype == null) {
            ClassLoader pcl;
            TypeRegistry tr = this;
            while (rtype == null && (tr = TypeRegistry.getTypeRegistryFor(pcl = tr.getClassLoader().getParent())) != null) {
                rtype = tr.getReloadableType(classname, false);
            }
            if (rtype != null) {
                return rtype;
            }
        }
        return rtype;
    }

    public ReloadableType getReloadableType(String slashedClassname, boolean allocateIdIfNotYetLoaded) {
        if (allocateIdIfNotYetLoaded) {
            return this.getReloadableType(this.getTypeIdFor(slashedClassname, allocateIdIfNotYetLoaded));
        }
        for (int i = 0; i < this.reloadableTypesSize; ++i) {
            ReloadableType rtype = this.reloadableTypes[i];
            if (rtype == null || !rtype.getSlashedName().equals(slashedClassname)) continue;
            return rtype;
        }
        return null;
    }

    Class<?> defineClass(String name, byte[] bytes, boolean permanent) {
        ChildClassLoader ccl;
        Class clazz = null;
        ChildClassLoader childClassLoader = ccl = this.childClassLoader == null ? null : (ChildClassLoader)this.childClassLoader.get();
        if (ccl == null) {
            ccl = new ChildClassLoader(this.getClassLoader());
            this.childClassLoader = new WeakReference<ChildClassLoader>(ccl);
        }
        try {
            if (permanent) {
                if (this.defineClassMethod == null) {
                    this.defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, bytes.getClass(), Integer.TYPE, Integer.TYPE);
                }
                this.defineClassMethod.setAccessible(true);
                ClassLoader loaderToUse = null;
                loaderToUse = (ClassLoader)this.classLoader.get();
                clazz = (Class)this.defineClassMethod.invoke((Object)loaderToUse, name, bytes, 0, bytes.length);
            } else {
                clazz = ccl.defineClass(name, bytes);
            }
        }
        catch (InvocationTargetException e) {
            throw new ReloadException("Problem defining class " + name, e);
        }
        catch (Exception e) {
            throw new ReloadException("Problem defining class " + name, e);
        }
        return clazz;
    }

    public TypeDescriptorExtractor getExtractor() {
        return this.extractor;
    }

    public Map<String, String> getRebasePaths() {
        return this.rebasePaths;
    }

    public boolean shouldDefineClasses() {
        return this.directlyDefineTypes;
    }

    public void setShouldDefineClasses(boolean should) {
        this.directlyDefineTypes = should;
    }

    @UsedByGeneratedCode
    public static Object idycheck() {
        if (nothingReloaded) {
            return null;
        }
        return "reloading-happened";
    }

    @UsedByGeneratedCode
    public static Object istcheck(int ids, String nameAndDescriptor) {
        if (nothingReloaded) {
            return null;
        }
        int registryId = ids >>> 16;
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[registryId].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType == null) {
            reloadableType = TypeRegistry.searchForReloadableType(typeId, typeRegistry);
        }
        if (reloadableType != null && !reloadableType.isAffectedByReload()) {
            return null;
        }
        if (reloadableType != null && reloadableType.hasBeenReloaded()) {
            MethodMember method = reloadableType.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
            boolean dispatchThroughDescriptor = false;
            if (method == null) {
                Object dispatcherToUse = null;
                String supertypename = reloadableType.getTypeDescriptor().getSupertypeName();
                TypeRegistry reg = reloadableType.getTypeRegistry();
                boolean found = false;
                while (supertypename != null) {
                    ReloadableType nextInHierarchy = reg.getReloadableType(supertypename);
                    if (nextInHierarchy == null) {
                        TypeDescriptor td = reg.getDescriptorFor(supertypename);
                        if (td == null) break;
                        method = td.getByNameAndDescriptor(nameAndDescriptor);
                        supertypename = td.getSupertypeName();
                    } else if (nextInHierarchy.hasBeenReloaded()) {
                        method = nextInHierarchy.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
                        if (method != null && IncrementalTypeDescriptor.wasDeleted(method)) {
                            method = null;
                        }
                        if (method != null && (MethodMember.isCatcher(method) || MethodMember.isSuperDispatcher(method))) {
                            method = null;
                        }
                    } else {
                        method = nextInHierarchy.getMethod(nameAndDescriptor);
                    }
                    if (method != null) {
                        found = true;
                        break;
                    }
                    if (nextInHierarchy == null) continue;
                    supertypename = nextInHierarchy.getSlashedSupertypeName();
                }
                if (found) {
                    return dispatcherToUse;
                }
                throw new NoSuchMethodError(reloadableType.getBaseName() + "." + nameAndDescriptor);
            }
            if (IncrementalTypeDescriptor.isBrandNewMethod(method)) {
                dispatchThroughDescriptor = true;
            } else if (IncrementalTypeDescriptor.hasChanged(method) && IncrementalTypeDescriptor.isNowNonStatic(method)) {
                throw new IncompatibleClassChangeError("SpringLoaded: Target of static call is no longer static '" + reloadableType.getBaseName() + "." + nameAndDescriptor + "'");
            }
            if (dispatchThroughDescriptor) {
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
                    log.info("istcheck(): reloadabletype=" + reloadableType + " versionstamp " + reloadableType.getLiveVersion().versionstamp);
                }
                return reloadableType.getLatestDispatcherInstance();
            }
        }
        return null;
    }

    public static Object invokespecialSearch(ReloadableType rt, String nameAndDescriptor) {
        ReloadableType next = rt;
        while (next != null) {
            MethodMember m = null;
            if (next.hasBeenReloaded()) {
                m = next.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
                if (m != null && IncrementalTypeDescriptor.wasDeleted(m)) {
                    m = null;
                }
                if (m != null && (MethodMember.isCatcher(m) || MethodMember.isSuperDispatcher(m))) {
                    m = null;
                }
            } else {
                m = next.getMethod(nameAndDescriptor);
            }
            if (m != null) {
                if (next.hasBeenReloaded()) {
                    return next.getLatestDispatcherInstance();
                }
                return null;
            }
            next = next.getTypeRegistry().getReloadableType(next.getTypeDescriptor().getSupertypeName(), false);
        }
        return null;
    }

    public static Object iiIntercept(Object instance, Object[] params, Object instance2, String nameAndDescriptor) {
        Class<?> clazz = instance.getClass();
        try {
            if (clazz.getName().contains("$$Lambda")) {
                Method[] ms = instance.getClass().getDeclaredMethods();
                Method m = ms[0];
                m.setAccessible(true);
                Object o = m.invoke(instance, params);
                return o;
            }
            Method m = instance.getClass().getDeclaredMethod("__execute", Object[].class, Object.class, String.class);
            m.setAccessible(true);
            return m.invoke(instance, params, instance, nameAndDescriptor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @UsedByGeneratedCode
    public static __DynamicallyDispatchable ispcheck(int ids, String nameAndDescriptor) {
        if (nothingReloaded) {
            return null;
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.entering("TypeRegistry", "spcheck", new Object[]{ids, nameAndDescriptor});
        }
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[ids >>> 16].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType == null) {
            reloadableType = TypeRegistry.searchForReloadableType(typeId, typeRegistry);
        }
        __DynamicallyDispatchable o = (__DynamicallyDispatchable)TypeRegistry.invokespecialSearch(reloadableType, nameAndDescriptor);
        return o;
    }

    private static ReloadableType searchForReloadableType(int typeId, TypeRegistry typeRegistry) {
        ReloadableType reloadableType = typeRegistry.getReloadableTypeInTypeRegistryHierarchy(NameRegistry.getTypenameById(typeId));
        typeRegistry.rememberReloadableType(typeId, reloadableType);
        return reloadableType;
    }

    @UsedByGeneratedCode
    public static Object ccheck(int ids, String descriptor) {
        if (nothingReloaded) {
            return null;
        }
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[ids >>> 16].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType != null && reloadableType.hasBeenReloaded() && reloadableType.cchanged(descriptor)) {
            return reloadableType.getLatestDispatcherInstance();
        }
        return null;
    }

    @UsedByGeneratedCode
    public static boolean iincheck(int ids, String nameAndDescriptor) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.entering("TypeRegistry", "iincheck", new Object[]{ids, nameAndDescriptor});
        }
        int registryId = ids >>> 16;
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[registryId].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType == null) {
            reloadableType = TypeRegistry.searchForReloadableType(typeId, typeRegistry);
        }
        if (reloadableType != null && !reloadableType.isAffectedByReload()) {
            return false;
        }
        if (reloadableType != null && reloadableType.hasBeenReloaded()) {
            MethodMember method = reloadableType.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
            boolean dispatchThroughDescriptor = false;
            if (method == null) {
                throw new NoSuchMethodError(reloadableType.getBaseName() + "." + nameAndDescriptor);
            }
            if (IncrementalTypeDescriptor.isBrandNewMethod(method)) {
                dispatchThroughDescriptor = true;
            }
            if (dispatchThroughDescriptor) {
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
                    log.info("versionstamp " + reloadableType.getLiveVersion().versionstamp);
                    log.exiting("TypeRegistry", "iincheck", true);
                }
                return true;
            }
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.exiting("TypeRegistry", "icheck", false);
        }
        return false;
    }

    @UsedByGeneratedCode
    public static boolean instanceFieldInterceptionRequired(int ids, String name) {
        if (nothingReloaded) {
            return false;
        }
        int registryId = ids >>> 16;
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[registryId].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        return reloadableType != null && reloadableType.hasFieldChangedInHierarchy(name);
    }

    @UsedByGeneratedCode
    public static boolean staticFieldInterceptionRequired(int ids, String name) {
        if (nothingReloaded) {
            return false;
        }
        int registryId = ids >>> 16;
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[registryId].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        return reloadableType != null && reloadableType.hasFieldChangedInHierarchy(name);
    }

    @UsedByGeneratedCode
    public static Object idyrun(Object[] indyParams, int typeRegistryId, int classId, Object caller, String nameAndDescriptor, int bsmId) {
        ReloadableType rtype = TypeRegistry.getReloadableType(typeRegistryId, classId);
        BsmInfo bsmi = bsmmap.get(rtype.getSlashedName())[bsmId];
        return Java8.emulateInvokeDynamic(rtype, rtype.getLatestExecutorClass(), bsmi.bsm, bsmi.bsmArgs, caller, nameAndDescriptor, indyParams);
    }

    @UsedByGeneratedCode
    public static boolean ivicheck(int ids, String nameAndDescriptor) {
        if (nothingReloaded) {
            return false;
        }
        int registryId = ids >>> 16;
        int typeId = ids & 0xFFFF;
        TypeRegistry typeRegistry = (TypeRegistry)registryInstances[registryId].get();
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType == null) {
            reloadableType = TypeRegistry.searchForReloadableType(typeId, typeRegistry);
        }
        if (reloadableType != null && !reloadableType.isAffectedByReload()) {
            return false;
        }
        if (reloadableType != null && reloadableType.hasBeenReloaded()) {
            MethodMember method = reloadableType.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
            boolean dispatchThroughDescriptor = false;
            if (method == null) {
                if (!reloadableType.getTypeDescriptor().isFinalInHierarchy(nameAndDescriptor)) {
                    throw new NoSuchMethodError(reloadableType.getBaseName() + "." + nameAndDescriptor);
                }
            } else if (IncrementalTypeDescriptor.isBrandNewMethod(method)) {
                dispatchThroughDescriptor = true;
            } else if (IncrementalTypeDescriptor.hasChanged(method) && !IncrementalTypeDescriptor.isCatcher(method) && !IncrementalTypeDescriptor.wasDeleted(method)) {
                dispatchThroughDescriptor = true;
            }
            if (dispatchThroughDescriptor) {
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
                    log.info("versionstamp " + reloadableType.getLiveVersion().versionstamp);
                    log.exiting("TypeRegistry", "ivicheck", true);
                }
                return true;
            }
        }
        return false;
    }

    private String getTypeById(int typeId) {
        return NameRegistry.getTypenameById(typeId);
    }

    @UsedByGeneratedCode
    public static ReloadableType getReloadableType(int typeRegistryId, int typeId) {
        TypeRegistry typeRegistry;
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
            log.info(">TypeRegistry.getReloadableType(typeRegistryId=" + typeRegistryId + ",typeId=" + typeId + ")");
        }
        if ((typeRegistry = (TypeRegistry)registryInstances[typeRegistryId].get()) == null) {
            throw new IllegalStateException("Request to access registry id " + typeRegistryId + " but no registry with that id has been created");
        }
        ReloadableType reloadableType = typeRegistry.getReloadableType(typeId);
        if (reloadableType == null) {
            throw new IllegalStateException("The type registry " + typeRegistry + " does not know about type id " + typeId);
        }
        reloadableType.setResolved();
        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
            log.info("<TypeRegistry.getReloadableType(typeRegistryId=" + typeRegistryId + ",typeId=" + typeId + ") returning " + reloadableType);
        }
        reloadableType.createTypeAssociations();
        return reloadableType;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("TypeRegistry(id=");
        s.append(System.identityHashCode(this));
        s.append(",loader=" + ((ClassLoader)this.classLoader.get()).getClass().getName());
        s.append(")");
        return s.toString();
    }

    public void monitorForUpdates(ReloadableType rtype, String externalForm) {
        if (externalForm.charAt(1) == ':') {
            externalForm = Character.toLowerCase(externalForm.charAt(0)) + externalForm.substring(1);
        }
        if (!this.rebasePaths.isEmpty()) {
            String forwardSlashForm = externalForm.replace('\\', '/');
            for (Map.Entry<String, String> path : this.rebasePaths.entrySet()) {
                System.out.println("Comparing " + forwardSlashForm + " with " + path.getKey());
                if (!forwardSlashForm.startsWith(path.getKey())) continue;
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                    log.info("Rebasing from " + externalForm);
                }
                externalForm = path.getValue() + externalForm.substring(path.getKey().length());
                if (!GlobalConfiguration.isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                log.info("Now " + externalForm);
            }
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("Called to monitor " + rtype.dottedtypename + " from " + externalForm);
        }
        if (!this.watching.contains(externalForm)) {
            File f = new File(externalForm);
            if (this.fileChangeListener == null) {
                this.fileChangeListener = new ReloadableFileChangeListener(this);
            }
            if (this.fsWatcher == null) {
                this.fsWatcher = new FileSystemWatcher(this.fileChangeListener, this.id, this.getClassLoaderName());
            }
            this.fileChangeListener.register(rtype, f);
            this.fsWatcher.register(f);
            this.watching.add(externalForm);
        }
    }

    private String getClassLoaderName() {
        ClassLoader cl = this.getClassLoader();
        if (cl == null) {
            return "NULL";
        }
        return cl.toString();
    }

    public boolean shouldRerunStaticInitializer(ReloadableType reloadableType, String versionsuffix) {
        for (Plugin plugin : this.localPlugins) {
            if (!(plugin instanceof ReloadEventProcessorPlugin) || !((ReloadEventProcessorPlugin)plugin).shouldRerunStaticInitializer(reloadableType.getName(), reloadableType.getClazz(), versionsuffix)) continue;
            return true;
        }
        for (Plugin plugin : SpringLoadedPreProcessor.getGlobalPlugins()) {
            if (!(plugin instanceof ReloadEventProcessorPlugin) || !((ReloadEventProcessorPlugin)plugin).shouldRerunStaticInitializer(reloadableType.getName(), reloadableType.getClazz(), versionsuffix)) continue;
            return true;
        }
        return false;
    }

    public void fireReloadEvent(ReloadableType reloadableType, String versionsuffix) {
        for (Plugin plugin : this.localPlugins) {
            if (!(plugin instanceof ReloadEventProcessorPlugin)) continue;
            ((ReloadEventProcessorPlugin)plugin).reloadEvent(reloadableType.getName(), reloadableType.getClazz(), versionsuffix);
        }
        for (Plugin plugin : SpringLoadedPreProcessor.getGlobalPlugins()) {
            if (!(plugin instanceof ReloadEventProcessorPlugin)) continue;
            ((ReloadEventProcessorPlugin)plugin).reloadEvent(reloadableType.getName(), reloadableType.getClazz(), versionsuffix);
        }
    }

    public boolean fireUnableToReloadEvent(ReloadableType reloadableType, TypeDelta td, String versionsuffix) {
        boolean calledSomething = false;
        for (Plugin plugin : this.localPlugins) {
            if (!(plugin instanceof UnableToReloadEventProcessorPlugin)) continue;
            ((UnableToReloadEventProcessorPlugin)plugin).unableToReloadEvent(reloadableType.getName(), reloadableType.getClazz(), td, versionsuffix);
            calledSomething = true;
        }
        for (Plugin plugin : SpringLoadedPreProcessor.getGlobalPlugins()) {
            if (!(plugin instanceof UnableToReloadEventProcessorPlugin)) continue;
            ((UnableToReloadEventProcessorPlugin)plugin).unableToReloadEvent(reloadableType.getName(), reloadableType.getClazz(), td, versionsuffix);
            calledSomething = true;
        }
        return calledSomething;
    }

    private List<TypePattern> getPatternsFrom(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<TypePattern> typePatterns = new ArrayList<TypePattern>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String typepattern = st.nextToken();
            TypePattern typePattern = null;
            if (typepattern.endsWith("..*")) {
                typePattern = new PrefixTypePattern(typepattern);
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                    log.info("registered package prefix '" + typepattern + "'");
                }
            } else {
                typePattern = typepattern.equals("*") ? new AnyTypePattern() : new ExactTypePattern(typepattern);
            }
            typePatterns.add(typePattern);
        }
        return typePatterns;
    }

    public Class<?> getClass_GroovySystem() {
        if (this.class_GroovySystem == null) {
            try {
                this.class_GroovySystem = Class.forName("groovy.lang.GroovySystem", false, (ClassLoader)this.classLoader.get());
            }
            catch (ClassNotFoundException e) {
                new RuntimeException("Unable to located GroovySystem to reset type", e).printStackTrace();
            }
        }
        return this.class_GroovySystem;
    }

    public Class<?> getClass_ClassInfo() {
        if (this.class_ClassInfo == null) {
            try {
                this.class_ClassInfo = Class.forName("org.codehaus.groovy.reflection.ClassInfo", false, (ClassLoader)this.classLoader.get());
            }
            catch (ClassNotFoundException e) {
                new RuntimeException("Unable to located ClassInfo to reset type", e).printStackTrace();
            }
        }
        return this.class_ClassInfo;
    }

    public Method getMethod_ClassInfo_getClassInfo() {
        if (this.method_ClassInfo_getClassInfo == null) {
            Class<?> clazz = this.getClass_ClassInfo();
            try {
                this.method_ClassInfo_getClassInfo = clazz.getDeclaredMethod("getClassInfo", Class.class);
            }
            catch (Exception e) {
                new RuntimeException("Unable to located method getClassInfo to reset type", e).printStackTrace();
            }
        }
        return this.method_ClassInfo_getClassInfo;
    }

    public Field getField_ClassInfo_cachedClassRef() {
        if (this.field_ClassInfo_cachedClassRef == null) {
            Class<?> clazz = this.getClass_ClassInfo();
            try {
                this.field_ClassInfo_cachedClassRef = clazz.getDeclaredField("cachedClassRef");
            }
            catch (Exception e) {
                new RuntimeException("Unable to located field cachedClassRef to reset type", e).printStackTrace();
            }
        }
        return this.field_ClassInfo_cachedClassRef;
    }

    public void checkChildClassLoader(ReloadableType currentlyDefining) {
        ChildClassLoader ccl = this.childClassLoader == null ? null : (ChildClassLoader)this.childClassLoader.get();
        int definedCount = ccl == null ? 0 : ccl.getDefinedCount();
        long time = System.currentTimeMillis();
        if (definedCount > this.maxClassDefinitions && time - this.lastTidyup > 5000L) {
            ReloadableType rtype;
            int i;
            this.lastTidyup = time;
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("Recreating the typeregistry managed classloader, limit(#" + GlobalConfiguration.maxClassDefinitions + ") reached");
            }
            ccl = new ChildClassLoader((ClassLoader)this.classLoader.get());
            this.childClassLoader = new WeakReference<ChildClassLoader>(ccl);
            for (i = 0; i < this.reloadableTypesSize; ++i) {
                rtype = this.reloadableTypes[i];
                if (rtype == null || rtype == currentlyDefining) continue;
                rtype.clearClassloaderLinks();
                rtype.reloadMostRecentDispatcherAndExecutor();
            }
            for (i = 0; i < this.reloadableTypesSize; ++i) {
                rtype = this.reloadableTypes[i];
                if (rtype == null || rtype == currentlyDefining || !rtype.hasBeenReloaded() || !rtype.getLiveVersion().staticInitializedNeedsRerunningOnDefine) continue;
                rtype.runStaticInitializer();
            }
            int count = ccl.getDefinedCount() + 3;
            if (count > this.maxClassDefinitions) {
                this.maxClassDefinitions = count;
            }
        }
    }

    public ChildClassLoader getChildClassLoader() {
        return (ChildClassLoader)this.childClassLoader.get();
    }

    public boolean isResolved(Class<?> clazz) {
        String n = clazz.getName().replace('.', '/');
        ReloadableType rt = this.getReloadableType(n);
        if (rt == null) {
            throw new IllegalStateException("reloadable type not found for " + n);
        }
        return rt.isResolved();
    }

    public ReloadableType getReloadableType(Class<?> clazz) {
        for (int r = 0; r < this.reloadableTypesSize; ++r) {
            ReloadableType rt = this.reloadableTypes[r];
            if (rt == null || rt.getClazz() != clazz) continue;
            return rt;
        }
        return null;
    }

    public TypeRegistry getParentRegistry() {
        ClassLoader cl = (ClassLoader)this.classLoader.get();
        if (cl == null) {
            return null;
        }
        return TypeRegistry.getTypeRegistryFor(cl.getParent());
    }

    public ReloadableType[] getReloadableTypes() {
        return this.reloadableTypes;
    }

    public Set<ReloadableType> getJDKProxiesFor(String slashedInterfaceTypeName) {
        return this.jdkProxiesForInterface.get(slashedInterfaceTypeName);
    }

    public synchronized int recordBootstrapMethod(String slashedClassName, Handle bsm, Object[] bsmArgs) {
        BsmInfo[] bsminfo;
        if (bsmmap == null) {
            bsmmap = new HashMap<String, BsmInfo[]>();
        }
        if ((bsminfo = bsmmap.get(slashedClassName)) == null) {
            bsminfo = new BsmInfo[]{new BsmInfo(bsm, bsmArgs)};
            bsmmap.put(slashedClassName, bsminfo);
            return 0;
        }
        int len = bsminfo.length;
        BsmInfo[] newarray = new BsmInfo[len + 1];
        System.arraycopy(bsminfo, 0, newarray, 0, len);
        bsminfo = newarray;
        bsmmap.put(slashedClassName, bsminfo);
        bsminfo[len] = new BsmInfo(bsm, bsmArgs);
        return len;
    }

    @UsedByGeneratedCode
    public static void associateReloadableType(ReloadableType child, Class<?> parent) {
        ClassLoader parentClassLoader = parent.getClassLoader();
        if (parentClassLoader == null) {
            return;
        }
        TypeRegistry parentTypeRegistry = TypeRegistry.getTypeRegistryFor(parent.getClassLoader());
        ReloadableType parentReloadableType = parentTypeRegistry.getReloadableType(parent);
        if (parentReloadableType != null) {
            parentReloadableType.recordSubtype(child);
        }
    }

    static {
        log = Logger.getLogger(TypeRegistry.class.getName());
        nothingReloaded = true;
        ignorablePackagePrefixes = new String[26][];
        TypeRegistry.ignorablePackagePrefixes[0] = new String[]{"antlr/"};
        TypeRegistry.ignorablePackagePrefixes[2] = new String[]{"com/springsource/tcserver/", "com/springsource/insight"};
        TypeRegistry.ignorablePackagePrefixes[6] = new String[]{"groovy/", "groovyjarjarantlr/", "groovyjarjarasm/", "grails/"};
        TypeRegistry.ignorablePackagePrefixes[9] = new String[]{"java/", "javassist/", "javax/"};
        TypeRegistry.ignorablePackagePrefixes[14] = new String[]{"org/springsource/loaded/", "org/objectweb/asm", "org/codehaus/groovy/", "org/apache/", "org/springframework/", "org/hibernate/", "org/hsqldb/", "org/aspectj/", "org/xml/", "org/h2/"};
        STANDARD_EXCLUDED_LOADERS = new String[]{"sun.misc.Launcher$ExtClassLoader", "sun.reflect.DelegatingClassLoader", "javax.management.remote.rmi.NoCallStackClassLoader", "org.springsource.loaded.ChildClassLoader", "org.apache.jasper.servlet.JasperLoader"};
        nextFreeRegistryId = 0;
        loaderToRegistryMap = Collections.synchronizedMap(new WeakHashMap());
        excludedLoaders = STANDARD_EXCLUDED_LOADERS;
        excludedLoaderInstances = new ArrayList<String>();
        getResourceMethod = null;
        registryInstances = new WeakReference[10];
    }

    static class BsmInfo {
        Handle bsm;
        Object[] bsmArgs;

        public BsmInfo(Handle bsm, Object[] bsmArgs) {
            this.bsm = bsm;
            this.bsmArgs = bsmArgs;
        }
    }
}

