/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.adapter.AbstractWebSocketSession;

public class JettyWebSocketSession
extends AbstractWebSocketSession<Session> {
    private final String id = idGenerator.generateId().toString();
    @Nullable
    private URI uri;
    @Nullable
    private HttpHeaders headers;
    @Nullable
    private String acceptedProtocol;
    @Nullable
    private List<WebSocketExtension> extensions;
    @Nullable
    private Principal user;

    public JettyWebSocketSession(Map<String, Object> attributes) {
        this(attributes, null);
    }

    public JettyWebSocketSession(Map<String, Object> attributes, @Nullable Principal user) {
        super(attributes);
        this.user = user;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public URI getUri() {
        this.checkNativeSessionInitialized();
        return this.uri;
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        Assert.state((this.headers != null ? 1 : 0) != 0, (String)"WebSocket session is not yet initialized");
        return this.headers;
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkNativeSessionInitialized();
        return this.acceptedProtocol;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        Assert.state((this.extensions != null ? 1 : 0) != 0, (String)"WebSocket session is not yet initialized");
        return this.extensions;
    }

    @Override
    public Principal getPrincipal() {
        return this.user;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.checkNativeSessionInitialized();
        return (InetSocketAddress)((Session)this.getNativeSession()).getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        this.checkNativeSessionInitialized();
        return (InetSocketAddress)((Session)this.getNativeSession()).getRemoteAddress();
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
    }

    @Override
    public int getTextMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return (int)((Session)this.getNativeSession()).getMaxTextMessageSize();
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return (int)((Session)this.getNativeSession()).getMaxBinaryMessageSize();
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getNativeSession()).isOpen();
    }

    @Override
    public void initializeNativeSession(Session session) {
        super.initializeNativeSession(session);
        this.uri = session.getUpgradeRequest().getRequestURI();
        HttpHeaders headers = new HttpHeaders();
        Map nativeHeaders = session.getUpgradeRequest().getHeaders();
        if (!CollectionUtils.isEmpty((Map)nativeHeaders)) {
            headers.putAll(nativeHeaders);
        }
        this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
        this.acceptedProtocol = session.getUpgradeResponse().getAcceptedSubProtocol();
        this.extensions = this.getExtensions(session);
        if (this.user == null) {
            this.user = session.getUpgradeRequest().getUserPrincipal();
        }
    }

    private List<WebSocketExtension> getExtensions(Session session) {
        List configs = session.getUpgradeResponse().getExtensions();
        if (!CollectionUtils.isEmpty((Collection)configs)) {
            ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>(configs.size());
            for (ExtensionConfig config : configs) {
                result.add(new WebSocketExtension(config.getName(), config.getParameters()));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        this.getRemoteEndpoint().sendString((String)message.getPayload());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        this.getRemoteEndpoint().sendBytes((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPingMessage(PingMessage message) throws IOException {
        this.getRemoteEndpoint().sendPing((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPongMessage(PongMessage message) throws IOException {
        this.getRemoteEndpoint().sendPong((ByteBuffer)message.getPayload());
    }

    private RemoteEndpoint getRemoteEndpoint() {
        return ((Session)this.getNativeSession()).getRemote();
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        ((Session)this.getNativeSession()).close(status.getCode(), status.getReason());
    }
}

