/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractTyrusRequestUpgradeStrategy;

public class WebLogicRequestUpgradeStrategy
extends AbstractTyrusRequestUpgradeStrategy {
    private static final boolean WLS_12_1_3 = WebLogicRequestUpgradeStrategy.isWebLogic1213();
    private static final AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper endpointHelper = WLS_12_1_3 ? new AbstractTyrusRequestUpgradeStrategy.Tyrus135EndpointHelper() : new AbstractTyrusRequestUpgradeStrategy.Tyrus17EndpointHelper();
    private static final TyrusMuxableWebSocketHelper webSocketHelper = new TyrusMuxableWebSocketHelper();
    private static final WebLogicServletWriterHelper servletWriterHelper = new WebLogicServletWriterHelper();
    private static final Connection.CloseListener noOpCloseListener = new Connection.CloseListener(){

        public void close(CloseReason reason) {
        }
    };

    @Override
    protected AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper getEndpointHelper() {
        return endpointHelper;
    }

    @Override
    protected void handleSuccess(HttpServletRequest request, HttpServletResponse response, WebSocketEngine.UpgradeInfo upgradeInfo, TyrusUpgradeResponse upgradeResponse) throws IOException, ServletException {
        response.setStatus(upgradeResponse.getStatus());
        for (Map.Entry entry : upgradeResponse.getHeaders().entrySet()) {
            response.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(-1L);
        Object nativeRequest = WebLogicRequestUpgradeStrategy.getNativeRequest((ServletRequest)request);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(nativeRequest);
        Object httpSocket = beanWrapper.getPropertyValue("connection.connectionHandler.rawConnection");
        Object webSocket = WebLogicRequestUpgradeStrategy.webSocketHelper.newInstance(request, httpSocket);
        WebLogicRequestUpgradeStrategy.webSocketHelper.upgrade(webSocket, httpSocket, request.getServletContext());
        response.flushBuffer();
        boolean isProtected = request.getUserPrincipal() != null;
        Writer servletWriter = WebLogicRequestUpgradeStrategy.servletWriterHelper.newInstance(response, webSocket, isProtected);
        Connection connection = upgradeInfo.createConnection(servletWriter, noOpCloseListener);
        new BeanWrapperImpl(webSocket).setPropertyValue("connection", (Object)connection);
        new BeanWrapperImpl((Object)servletWriter).setPropertyValue("connection", (Object)connection);
        WebLogicRequestUpgradeStrategy.webSocketHelper.registerForReadEvent(webSocket);
    }

    private static boolean isWebLogic1213() {
        try {
            WebLogicRequestUpgradeStrategy.type("weblogic.websocket.tyrus.TyrusMuxableWebSocket").getDeclaredConstructor(WebLogicRequestUpgradeStrategy.type("weblogic.servlet.internal.MuxableSocketHTTP"));
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("No compatible WebSocket version found", ex);
        }
    }

    private static Class<?> type(String className) throws ClassNotFoundException {
        return WebLogicRequestUpgradeStrategy.class.getClassLoader().loadClass(className);
    }

    private static Method method(String className, String method, Class<?> ... paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return WebLogicRequestUpgradeStrategy.type(className).getDeclaredMethod(method, paramTypes);
    }

    private static Object getNativeRequest(ServletRequest request) {
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return request;
    }

    private static class WebLogicServletWriterHelper {
        private static final Constructor<?> constructor;

        private WebLogicServletWriterHelper() {
        }

        private Writer newInstance(HttpServletResponse response, Object webSocket, boolean isProtected) {
            try {
                Object[] objectArray;
                if (WLS_12_1_3) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = webSocket;
                    objectArray2[1] = response;
                    objectArray2[2] = null;
                    objectArray = objectArray2;
                    objectArray2[3] = isProtected;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = webSocket;
                    objectArray3[1] = null;
                    objectArray = objectArray3;
                    objectArray3[2] = isProtected;
                }
                Object[] args = objectArray;
                return (Writer)constructor.newInstance(args);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to create TyrusServletWriter", ex);
            }
        }

        static {
            try {
                Class[] classArray;
                Class writerType = WebLogicRequestUpgradeStrategy.type("weblogic.websocket.tyrus.TyrusServletWriter");
                Class listenerType = WebLogicRequestUpgradeStrategy.type("weblogic.websocket.tyrus.TyrusServletWriter$CloseListener");
                Class webSocketType = TyrusMuxableWebSocketHelper.type;
                Class<HttpServletResponse> responseType = HttpServletResponse.class;
                if (WLS_12_1_3) {
                    Class[] classArray2 = new Class[4];
                    classArray2[0] = webSocketType;
                    classArray2[1] = responseType;
                    classArray2[2] = listenerType;
                    classArray = classArray2;
                    classArray2[3] = Boolean.TYPE;
                } else {
                    Class[] classArray3 = new Class[3];
                    classArray3[0] = webSocketType;
                    classArray3[1] = listenerType;
                    classArray = classArray3;
                    classArray3[2] = Boolean.TYPE;
                }
                Class[] argTypes = classArray;
                constructor = writerType.getDeclaredConstructor(argTypes);
                ReflectionUtils.makeAccessible(constructor);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible WebSocket version found", ex);
            }
        }
    }

    private static class SubjectHelper {
        private final Method securityContextMethod;
        private final Method currentUserMethod;
        private final Method providerMethod;
        private final Method anonymousSubjectMethod;

        public SubjectHelper() {
            try {
                String className = "weblogic.servlet.internal.WebAppServletContext";
                this.securityContextMethod = WebLogicRequestUpgradeStrategy.method(className, "getSecurityContext", new Class[0]);
                className = "weblogic.servlet.security.internal.SecurityModule";
                this.currentUserMethod = WebLogicRequestUpgradeStrategy.method(className, "getCurrentUser", new Class[]{WebLogicRequestUpgradeStrategy.type("weblogic.servlet.security.internal.ServletSecurityContext"), HttpServletRequest.class});
                className = "weblogic.servlet.security.internal.WebAppSecurity";
                this.providerMethod = WebLogicRequestUpgradeStrategy.method(className, "getProvider", new Class[0]);
                this.anonymousSubjectMethod = this.providerMethod.getReturnType().getDeclaredMethod("getAnonymousSubject", new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible WebSocket version found", ex);
            }
        }

        public Object getSubject(HttpServletRequest request) {
            try {
                ServletContext servletContext = request.getServletContext();
                Object securityContext = this.securityContextMethod.invoke((Object)servletContext, new Object[0]);
                Object subject = this.currentUserMethod.invoke(null, securityContext, request);
                if (subject == null) {
                    Object securityProvider = this.providerMethod.invoke(null, new Object[0]);
                    subject = this.anonymousSubjectMethod.invoke(securityProvider, new Object[0]);
                }
                return subject;
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to obtain SubjectHandle", ex);
            }
        }
    }

    private static class TyrusMuxableWebSocketHelper {
        private static final Class<?> type;
        private static final Constructor<?> constructor;
        private static final SubjectHelper subjectHelper;
        private static final Method upgradeMethod;
        private static final Method readEventMethod;

        private TyrusMuxableWebSocketHelper() {
        }

        private Object newInstance(HttpServletRequest request, Object httpSocket) {
            try {
                Object[] objectArray;
                if (WLS_12_1_3) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = httpSocket;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = httpSocket;
                    objectArray3[1] = null;
                    objectArray = objectArray3;
                    objectArray3[2] = subjectHelper.getSubject(request);
                }
                Object[] args = objectArray;
                return constructor.newInstance(args);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to create TyrusMuxableWebSocket", ex);
            }
        }

        private void upgrade(Object webSocket, Object httpSocket, ServletContext servletContext) {
            try {
                upgradeMethod.invoke(webSocket, httpSocket, servletContext);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to upgrade TyrusMuxableWebSocket", ex);
            }
        }

        private void registerForReadEvent(Object webSocket) {
            try {
                readEventMethod.invoke(webSocket, new Object[0]);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to register WebSocket for read event", ex);
            }
        }

        static {
            try {
                type = WebLogicRequestUpgradeStrategy.type("weblogic.websocket.tyrus.TyrusMuxableWebSocket");
                if (WLS_12_1_3) {
                    constructor = type.getDeclaredConstructor(WebLogicRequestUpgradeStrategy.type("weblogic.servlet.internal.MuxableSocketHTTP"));
                    subjectHelper = null;
                } else {
                    constructor = type.getDeclaredConstructor(WebLogicRequestUpgradeStrategy.type("weblogic.servlet.internal.MuxableSocketHTTP"), WebLogicRequestUpgradeStrategy.type("weblogic.websocket.tyrus.CoherenceServletFilterService"), WebLogicRequestUpgradeStrategy.type("weblogic.servlet.spi.SubjectHandle"));
                    subjectHelper = new SubjectHelper();
                }
                upgradeMethod = type.getMethod("upgrade", WebLogicRequestUpgradeStrategy.type("weblogic.socket.MuxableSocket"), ServletContext.class);
                readEventMethod = type.getMethod("registerForReadEvent", new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible WebSocket version found", ex);
            }
        }
    }
}

