/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.servlet.HandlerMapping;

public class ExtendedServletRequestDataBinder
extends ServletRequestDataBinder {
    private static final Set<String> FILTERED_HEADER_NAMES = Set.of("Priority");
    private Predicate<String> headerPredicate = name -> !FILTERED_HEADER_NAMES.contains(name);

    public ExtendedServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public ExtendedServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void addHeaderPredicate(Predicate<String> headerPredicate) {
        this.headerPredicate = this.headerPredicate.and(headerPredicate);
    }

    public void setHeaderPredicate(Predicate<String> headerPredicate) {
        this.headerPredicate = headerPredicate;
    }

    protected ServletRequestDataBinder.ServletRequestValueResolver createValueResolver(ServletRequest request) {
        return new ExtendedServletRequestValueResolver(request, (WebDataBinder)this);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(request);
        if (uriVars != null) {
            uriVars.forEach((name, value) -> ExtendedServletRequestDataBinder.addValueIfNotPresent(mpvs, "URI variable", name, value));
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Enumeration names = httpRequest.getHeaderNames();
            while (names.hasMoreElements()) {
                String name2 = (String)names.nextElement();
                Object value2 = this.getHeaderValue(httpRequest, name2);
                if (value2 == null) continue;
                name2 = StringUtils.uncapitalize((String)name2.replace("-", ""));
                ExtendedServletRequestDataBinder.addValueIfNotPresent(mpvs, "Header", name2, value2);
            }
        }
    }

    @Nullable
    private static Map<String, String> getUriVars(ServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }

    private static void addValueIfNotPresent(MutablePropertyValues mpvs, String label, String name, Object value) {
        if (mpvs.contains(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(label + " '" + name + "' overridden by request bind value."));
            }
        } else {
            mpvs.addPropertyValue(name, value);
        }
    }

    @Nullable
    private Object getHeaderValue(HttpServletRequest request, String name) {
        if (!this.headerPredicate.test(name)) {
            return null;
        }
        Enumeration valuesEnum = request.getHeaders(name);
        if (!valuesEnum.hasMoreElements()) {
            return null;
        }
        String value = (String)valuesEnum.nextElement();
        if (!valuesEnum.hasMoreElements()) {
            return value;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        while (valuesEnum.hasMoreElements()) {
            values.add((String)valuesEnum.nextElement());
        }
        return values;
    }

    private class ExtendedServletRequestValueResolver
    extends ServletRequestDataBinder.ServletRequestValueResolver {
        ExtendedServletRequestValueResolver(ServletRequest request, WebDataBinder dataBinder) {
            super(request, dataBinder);
        }

        @Nullable
        protected Object getRequestParameter(String name, Class<?> type) {
            Object value = super.getRequestParameter(name, type);
            if (value == null) {
                ServletRequest servletRequest;
                Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest());
                if (uriVars != null) {
                    value = uriVars.get(name);
                }
                if (value == null && (servletRequest = this.getRequest()) instanceof HttpServletRequest) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                    value = ExtendedServletRequestDataBinder.this.getHeaderValue(httpServletRequest, name);
                }
            }
            return value;
        }

        protected Set<String> initParameterNames(ServletRequest request) {
            Set set = super.initParameterNames(request);
            Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest());
            if (uriVars != null) {
                set.addAll(uriVars.keySet());
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                Enumeration enumeration = httpServletRequest.getHeaderNames();
                while (enumeration.hasMoreElements()) {
                    String headerName = (String)enumeration.nextElement();
                    set.add(headerName.replaceAll("-", ""));
                }
            }
            return set;
        }
    }
}

