/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.DefaultFragmentsRenderingBuilder;
import org.springframework.web.reactive.result.view.Fragment;
import reactor.core.publisher.Flux;

public interface FragmentsRendering {
    @Nullable
    public HttpStatusCode status();

    public HttpHeaders headers();

    public Flux<Fragment> fragments();

    public static Builder with(String viewName, Map<String, Object> model) {
        return FragmentsRendering.withCollection(List.of(Fragment.create(viewName, model)));
    }

    public static Builder with(String viewName) {
        return FragmentsRendering.withCollection(List.of(Fragment.create(viewName)));
    }

    public static Builder withCollection(Collection<Fragment> fragments) {
        return new DefaultFragmentsRenderingBuilder(fragments);
    }

    public static <P extends Publisher<Fragment>> Builder withPublisher(P fragmentsPublisher) {
        return new DefaultFragmentsRenderingBuilder(fragmentsPublisher);
    }

    public static Builder withProducer(Object fragmentsProducer) {
        return new DefaultFragmentsRenderingBuilder(FragmentsRendering.adaptProducer(fragmentsProducer));
    }

    private static Publisher<Fragment> adaptProducer(Object producer) {
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(producer.getClass());
        Assert.isTrue((adapter != null ? 1 : 0) != 0, (String)("Unknown producer " + producer.getClass()));
        return adapter.toPublisher(producer);
    }

    public static interface Builder {
        public Builder status(HttpStatusCode var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder fragment(String var1, Map<String, Object> var2);

        public Builder fragment(String var1);

        public Builder fragment(Fragment var1);

        public FragmentsRendering build();
    }
}

