/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.reactivestreams.Publisher;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.method.MethodValidator;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverComposite;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> EMPTY_ARGS = Mono.just((Object)new Object[0]);
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private static final Object NO_ARG_VALUE = new Object();
    private final HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    @Nullable
    private MethodValidator methodValidator;
    private Class<?>[] validationGroups = EMPTY_GROUPS;

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    public void setArgumentResolvers(List<? extends HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.addResolvers(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getResolvers() {
        return this.resolvers.getResolvers();
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.parameterNameDiscoverer = nameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public void setMethodValidator(@Nullable MethodValidator methodValidator) {
        this.methodValidator = methodValidator;
        this.validationGroups = methodValidator != null ? methodValidator.determineValidationGroups(this.getBean(), this.getBridgedMethod()) : EMPTY_GROUPS;
    }

    public Mono<HandlerResult> invoke(ServerWebExchange exchange2, BindingContext bindingContext, Object ... providedArgs) {
        return this.getMethodArgumentValues(exchange2, bindingContext, providedArgs).flatMap(args -> {
            Object value;
            if (this.shouldValidateArguments() && this.methodValidator != null) {
                this.methodValidator.applyArgumentValidation(this.getBean(), this.getBridgedMethod(), this.getMethodParameters(), args, (Class[])this.validationGroups);
            }
            Method method = this.getBridgedMethod();
            boolean isSuspendingFunction = KotlinDetector.isSuspendingFunction((Method)method);
            try {
                value = KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(method.getDeclaringClass()) ? KotlinDelegate.invokeFunction(method, this.getBean(), args, isSuspendingFunction, exchange2) : method.invoke(this.getBean(), args);
            }
            catch (IllegalArgumentException ex) {
                this.assertTargetBean(this.getBridgedMethod(), this.getBean(), (Object[])args);
                String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
                return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError(text, (Object[])args), ex));
            }
            catch (InvocationTargetException ex) {
                return Mono.error((Throwable)ex.getTargetException());
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError("Invocation failure", (Object[])args), ex));
            }
            HttpStatusCode status = this.getResponseStatus();
            if (status != null) {
                exchange2.getResponse().setStatusCode(status);
            }
            MethodParameter returnType = this.getReturnType();
            if (this.isResponseHandled((Object[])args, exchange2)) {
                Class parameterType = returnType.getParameterType();
                ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(parameterType);
                boolean asyncVoid = InvocableHandlerMethod.isAsyncVoidReturnType(returnType, adapter);
                if (value == null || asyncVoid) {
                    return asyncVoid ? Mono.from((Publisher)adapter.toPublisher(value)) : Mono.empty();
                }
                if (isSuspendingFunction && parameterType == Void.TYPE) {
                    return (Mono)value;
                }
            }
            HandlerResult result = new HandlerResult((Object)this, value, returnType, bindingContext);
            return Mono.just((Object)result);
        });
    }

    private Mono<Object[]> getMethodArgumentValues(ServerWebExchange exchange2, BindingContext bindingContext, Object ... providedArgs) {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])parameters)) {
            return EMPTY_ARGS;
        }
        ArrayList<Mono> argMonos = new ArrayList<Mono>(parameters.length);
        for (Object parameter : parameters) {
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            Object providedArg = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, (Object[])providedArgs);
            if (providedArg != null) {
                argMonos.add(Mono.just((Object)providedArg));
                continue;
            }
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                return Mono.error((Throwable)new IllegalStateException(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)"No suitable resolver")));
            }
            try {
                argMonos.add(this.resolvers.resolveArgument((MethodParameter)parameter, bindingContext, exchange2).defaultIfEmpty(NO_ARG_VALUE).doOnError(arg_0 -> this.lambda$getMethodArgumentValues$1(exchange2, (MethodParameter)parameter, arg_0)));
            }
            catch (Exception ex) {
                this.logArgumentErrorIfNecessary(exchange2, (MethodParameter)parameter, ex);
                argMonos.add(Mono.error((Throwable)ex));
            }
        }
        return Mono.zip(argMonos, values -> Stream.of(values).map(value -> value != NO_ARG_VALUE ? value : null).toArray());
    }

    private void logArgumentErrorIfNecessary(ServerWebExchange exchange2, MethodParameter parameter, Throwable ex) {
        String exMsg = ex.getMessage();
        if (exMsg != null && !exMsg.contains(parameter.getExecutable().toGenericString()) && logger.isDebugEnabled()) {
            logger.debug((Object)(exchange2.getLogPrefix() + InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)exMsg)));
        }
    }

    private static boolean isAsyncVoidReturnType(MethodParameter returnType, @Nullable ReactiveAdapter adapter) {
        if (adapter != null && adapter.supportsEmpty()) {
            ParameterizedType type;
            if (adapter.isNoValue()) {
                return true;
            }
            Type parameterType = returnType.getGenericParameterType();
            if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getActualTypeArguments().length == 1) {
                return Void.class.equals((Object)type.getActualTypeArguments()[0]);
            }
        }
        return false;
    }

    private boolean isResponseHandled(Object[] args, ServerWebExchange exchange2) {
        if (this.getResponseStatus() != null || exchange2.isNotModified()) {
            return true;
        }
        for (Object arg : args) {
            if (!(arg instanceof ServerHttpResponse) && !(arg instanceof ServerWebExchange)) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$getMethodArgumentValues$1(ServerWebExchange exchange2, MethodParameter parameter, Throwable ex) {
        this.logArgumentErrorIfNecessary(exchange2, parameter, ex);
    }

    private static class KotlinDelegate {
        private static final String COROUTINE_CONTEXT_ATTRIBUTE = "org.springframework.web.server.CoWebFilter.context";

        private KotlinDelegate() {
        }

        @Nullable
        public static Object invokeFunction(Method method, Object target, Object[] args, boolean isSuspendingFunction, ServerWebExchange exchange2) throws InvocationTargetException, IllegalAccessException {
            if (isSuspendingFunction) {
                Object coroutineContext = exchange2.getAttribute(COROUTINE_CONTEXT_ATTRIBUTE);
                if (coroutineContext == null) {
                    return CoroutinesUtils.invokeSuspendingFunction((Method)method, (Object)target, (Object[])args);
                }
                return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)((CoroutineContext)coroutineContext), (Method)method, (Object)target, (Object[])args);
            }
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
            if (function == null) {
                return method.invoke(target, args);
            }
            if (method.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
                KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
            }
            HashMap argMap = CollectionUtils.newHashMap((int)(args.length + 1));
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        Object arg = args[index];
                        if (!parameter.isOptional() || arg != null) {
                            KClass kClass;
                            KType type = parameter.getType();
                            if ((!type.isMarkedNullable() || arg != null) && KotlinDetector.isInlineClass((Class)JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)type.getClassifier())))) {
                                arg = KClasses.getPrimaryConstructor((KClass)kClass).call(new Object[]{arg});
                            }
                            argMap.put(parameter, arg);
                        }
                        ++index;
                    }
                }
            }
            Object result = function.callBy((Map)argMap);
            return result == Unit.INSTANCE ? null : result;
        }
    }
}

