/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.DefaultServerRequestBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ServerRequest {
    public HttpMethod method();

    @Deprecated(since="6.0")
    public String methodName();

    public URI uri();

    public UriBuilder uriBuilder();

    default public String path() {
        return this.requestPath().pathWithinApplication().value();
    }

    @Deprecated
    default public PathContainer pathContainer() {
        return this.requestPath();
    }

    default public RequestPath requestPath() {
        return this.exchange().getRequest().getPath();
    }

    public Headers headers();

    public MultiValueMap<String, HttpCookie> cookies();

    public Optional<InetSocketAddress> remoteAddress();

    public Optional<InetSocketAddress> localAddress();

    public List<HttpMessageReader<?>> messageReaders();

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1);

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1, Map<String, Object> var2);

    public <T> Mono<T> bodyToMono(Class<? extends T> var1);

    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> var1);

    public <T> Flux<T> bodyToFlux(Class<? extends T> var1);

    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> var1);

    default public <T> Mono<T> bind(Class<T> bindType) {
        return this.bind(bindType, dataBinder -> {});
    }

    public <T> Mono<T> bind(Class<T> var1, Consumer<WebDataBinder> var2);

    default public Optional<Object> attribute(String name) {
        return Optional.ofNullable(this.attributes().get(name));
    }

    public Map<String, Object> attributes();

    default public Optional<String> queryParam(String name) {
        List queryParamValues = (List)this.queryParams().get((Object)name);
        if (CollectionUtils.isEmpty((Collection)queryParamValues)) {
            return Optional.empty();
        }
        String value = (String)queryParamValues.get(0);
        if (value == null) {
            value = "";
        }
        return Optional.of(value);
    }

    public MultiValueMap<String, String> queryParams();

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return this.pathVariables().get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
    }

    public Map<String, String> pathVariables();

    public Mono<WebSession> session();

    public Mono<? extends Principal> principal();

    public Mono<MultiValueMap<String, String>> formData();

    public Mono<MultiValueMap<String, Part>> multipartData();

    public ServerWebExchange exchange();

    default public Mono<ServerResponse> checkNotModified(Instant lastModified) {
        Assert.notNull((Object)lastModified, (String)"LastModified must not be null");
        return DefaultServerRequest.checkNotModified(this.exchange(), lastModified, null);
    }

    default public Mono<ServerResponse> checkNotModified(String etag) {
        Assert.notNull((Object)etag, (String)"Etag must not be null");
        return DefaultServerRequest.checkNotModified(this.exchange(), null, etag);
    }

    default public Mono<ServerResponse> checkNotModified(Instant lastModified, String etag) {
        Assert.notNull((Object)lastModified, (String)"LastModified must not be null");
        Assert.notNull((Object)etag, (String)"Etag must not be null");
        return DefaultServerRequest.checkNotModified(this.exchange(), lastModified, etag);
    }

    public static ServerRequest create(ServerWebExchange exchange2, List<HttpMessageReader<?>> messageReaders) {
        return new DefaultServerRequest(exchange2, messageReaders);
    }

    public static Builder from(ServerRequest other) {
        return new DefaultServerRequestBuilder(other);
    }

    public static interface Builder {
        public Builder method(HttpMethod var1);

        public Builder uri(URI var1);

        public Builder contextPath(@Nullable String var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder cookie(String var1, String ... var2);

        public Builder cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public Builder body(Flux<DataBuffer> var1);

        public Builder body(String var1);

        public Builder attribute(String var1, Object var2);

        public Builder attributes(Consumer<Map<String, Object>> var1);

        public ServerRequest build();
    }

    public static interface Headers {
        public List<MediaType> accept();

        public List<Charset> acceptCharset();

        public List<Locale.LanguageRange> acceptLanguage();

        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        @Nullable
        public InetSocketAddress host();

        public List<HttpRange> range();

        public List<String> header(String var1);

        @Nullable
        default public String firstHeader(String headerName) {
            List<String> list = this.header(headerName);
            return list.isEmpty() ? null : list.get(0);
        }

        public HttpHeaders asHttpHeaders();
    }
}

