/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.function.server.support.HandlerFunctionAdapter;
import org.springframework.web.reactive.function.server.support.RouterFunctionMapping;
import org.springframework.web.reactive.function.server.support.ServerResponseResultHandler;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.reactive.handler.WebFluxResponseStatusExceptionHandler;
import org.springframework.web.reactive.resource.ResourceUrlProvider;
import org.springframework.web.reactive.result.SimpleHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.reactive.result.method.annotation.ResponseBodyResultHandler;
import org.springframework.web.reactive.result.method.annotation.ResponseEntityResultHandler;
import org.springframework.web.reactive.result.view.ViewResolutionResultHandler;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import org.springframework.web.server.i18n.LocaleContextResolver;
import reactor.core.publisher.Mono;

public class WebFluxConfigurationSupport
implements ApplicationContextAware {
    @Nullable
    private Map<String, CorsConfiguration> corsConfigurations;
    @Nullable
    private PathMatchConfigurer pathMatchConfigurer;
    @Nullable
    private ViewResolverRegistry viewResolverRegistry;
    @Nullable
    private ApplicationContext applicationContext;

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext != null) {
            Assert.state((!applicationContext.containsBean("mvcContentNegotiationManager") ? 1 : 0) != 0, (String)"The Java/XML config for Spring MVC and Spring WebFlux cannot both be enabled, e.g. via @EnableWebMvc and @EnableWebFlux, in the same application.");
        }
    }

    @Nullable
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Bean
    public DispatcherHandler webHandler() {
        return new DispatcherHandler();
    }

    @Bean
    @Order(value=0)
    public WebExceptionHandler responseStatusExceptionHandler() {
        return new WebFluxResponseStatusExceptionHandler();
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping(@Qualifier(value="webFluxContentTypeResolver") RequestedContentTypeResolver contentTypeResolver) {
        RequestMappingHandlerMapping mapping = this.createRequestMappingHandlerMapping();
        mapping.setOrder(0);
        mapping.setContentTypeResolver(contentTypeResolver);
        PathMatchConfigurer configurer = this.getPathMatchConfigurer();
        this.configureAbstractHandlerMapping(mapping, configurer);
        Map<String, Predicate<Class<?>>> pathPrefixes = configurer.getPathPrefixes();
        if (pathPrefixes != null) {
            mapping.setPathPrefixes(pathPrefixes);
        }
        return mapping;
    }

    private void configureAbstractHandlerMapping(AbstractHandlerMapping mapping, PathMatchConfigurer configurer) {
        Boolean useCaseSensitiveMatch;
        mapping.setCorsConfigurations(this.getCorsConfigurations());
        Boolean useTrailingSlashMatch = configurer.isUseTrailingSlashMatch();
        if (useTrailingSlashMatch != null) {
            mapping.setUseTrailingSlashMatch(useTrailingSlashMatch);
        }
        if ((useCaseSensitiveMatch = configurer.isUseCaseSensitiveMatch()) != null) {
            mapping.setUseCaseSensitiveMatch(useCaseSensitiveMatch);
        }
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    @Bean
    public RequestedContentTypeResolver webFluxContentTypeResolver() {
        RequestedContentTypeResolverBuilder builder = new RequestedContentTypeResolverBuilder();
        this.configureContentTypeResolver(builder);
        return builder.build();
    }

    protected void configureContentTypeResolver(RequestedContentTypeResolverBuilder builder) {
    }

    protected final Map<String, CorsConfiguration> getCorsConfigurations() {
        if (this.corsConfigurations == null) {
            CorsRegistry registry = new CorsRegistry();
            this.addCorsMappings(registry);
            this.corsConfigurations = registry.getCorsConfigurations();
        }
        return this.corsConfigurations;
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    protected final PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatching(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    public void configurePathMatching(PathMatchConfigurer configurer) {
    }

    @Bean
    public RouterFunctionMapping routerFunctionMapping(ServerCodecConfigurer serverCodecConfigurer) {
        RouterFunctionMapping mapping = this.createRouterFunctionMapping();
        mapping.setOrder(-1);
        mapping.setMessageReaders(serverCodecConfigurer.getReaders());
        this.configureAbstractHandlerMapping(mapping, this.getPathMatchConfigurer());
        return mapping;
    }

    protected RouterFunctionMapping createRouterFunctionMapping() {
        return new RouterFunctionMapping();
    }

    @Bean
    public HandlerMapping resourceHandlerMapping(ResourceUrlProvider resourceUrlProvider) {
        ApplicationContext resourceLoader = this.applicationContext;
        if (resourceLoader == null) {
            resourceLoader = new DefaultResourceLoader();
        }
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry((ResourceLoader)resourceLoader);
        registry.setResourceUrlProvider(resourceUrlProvider);
        this.addResourceHandlers(registry);
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        if (handlerMapping != null) {
            this.configureAbstractHandlerMapping(handlerMapping, this.getPathMatchConfigurer());
        } else {
            handlerMapping = new EmptyHandlerMapping();
        }
        return handlerMapping;
    }

    @Bean
    public ResourceUrlProvider resourceUrlProvider() {
        return new ResourceUrlProvider();
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter(@Qualifier(value="webFluxAdapterRegistry") ReactiveAdapterRegistry reactiveAdapterRegistry, ServerCodecConfigurer serverCodecConfigurer, @Qualifier(value="webFluxConversionService") FormattingConversionService conversionService, @Qualifier(value="webFluxValidator") Validator validator) {
        RequestMappingHandlerAdapter adapter = this.createRequestMappingHandlerAdapter();
        adapter.setMessageReaders(serverCodecConfigurer.getReaders());
        adapter.setWebBindingInitializer((WebBindingInitializer)this.getConfigurableWebBindingInitializer(conversionService, validator));
        adapter.setReactiveAdapterRegistry(reactiveAdapterRegistry);
        ArgumentResolverConfigurer configurer = new ArgumentResolverConfigurer();
        this.configureArgumentResolvers(configurer);
        adapter.setArgumentResolverConfigurer(configurer);
        return adapter;
    }

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    protected void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
    }

    @Bean
    public ServerCodecConfigurer serverCodecConfigurer() {
        ServerCodecConfigurer serverCodecConfigurer = ServerCodecConfigurer.create();
        this.configureHttpMessageCodecs(serverCodecConfigurer);
        return serverCodecConfigurer;
    }

    protected LocaleContextResolver createLocaleContextResolver() {
        return new AcceptHeaderLocaleContextResolver();
    }

    @Bean
    public LocaleContextResolver localeContextResolver() {
        return this.createLocaleContextResolver();
    }

    protected void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
    }

    protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer(FormattingConversionService webFluxConversionService, Validator webFluxValidator) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)webFluxConversionService);
        initializer.setValidator(webFluxValidator);
        MessageCodesResolver messageCodesResolver = this.getMessageCodesResolver();
        if (messageCodesResolver != null) {
            initializer.setMessageCodesResolver(messageCodesResolver);
        }
        return initializer;
    }

    @Bean
    public FormattingConversionService webFluxConversionService() {
        DefaultFormattingConversionService service = new DefaultFormattingConversionService();
        this.addFormatters((FormatterRegistry)service);
        return service;
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    @Bean
    public ReactiveAdapterRegistry webFluxAdapterRegistry() {
        return new ReactiveAdapterRegistry();
    }

    @Bean
    public Validator webFluxValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
                Class clazz;
                try {
                    String name = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName((String)name, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException | LinkageError ex) {
                    throw new BeanInitializationException("Failed to resolve default validator class", ex);
                }
                validator = (Validator)BeanUtils.instantiateClass((Class)clazz);
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    @Nullable
    protected Validator getValidator() {
        return null;
    }

    @Nullable
    protected MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    @Bean
    public HandlerFunctionAdapter handlerFunctionAdapter() {
        return new HandlerFunctionAdapter();
    }

    @Bean
    public SimpleHandlerAdapter simpleHandlerAdapter() {
        return new SimpleHandlerAdapter();
    }

    @Bean
    public WebSocketHandlerAdapter webFluxWebSocketHandlerAdapter() {
        WebSocketHandlerAdapter adapter = new WebSocketHandlerAdapter(this.initWebSocketService());
        int defaultOrder = adapter.getOrder();
        adapter.setOrder(defaultOrder + 1);
        return adapter;
    }

    private WebSocketService initWebSocketService() {
        WebSocketService service = this.getWebSocketService();
        if (service == null) {
            try {
                service = new HandshakeWebSocketService();
            }
            catch (IllegalStateException ex) {
                service = new NoUpgradeStrategyWebSocketService();
            }
        }
        return service;
    }

    @Nullable
    protected WebSocketService getWebSocketService() {
        return null;
    }

    @Bean
    public ResponseEntityResultHandler responseEntityResultHandler(@Qualifier(value="webFluxAdapterRegistry") ReactiveAdapterRegistry reactiveAdapterRegistry, ServerCodecConfigurer serverCodecConfigurer, @Qualifier(value="webFluxContentTypeResolver") RequestedContentTypeResolver contentTypeResolver) {
        return new ResponseEntityResultHandler(serverCodecConfigurer.getWriters(), contentTypeResolver, reactiveAdapterRegistry);
    }

    @Bean
    public ResponseBodyResultHandler responseBodyResultHandler(@Qualifier(value="webFluxAdapterRegistry") ReactiveAdapterRegistry reactiveAdapterRegistry, ServerCodecConfigurer serverCodecConfigurer, @Qualifier(value="webFluxContentTypeResolver") RequestedContentTypeResolver contentTypeResolver) {
        return new ResponseBodyResultHandler(serverCodecConfigurer.getWriters(), contentTypeResolver, reactiveAdapterRegistry);
    }

    @Bean
    public ViewResolutionResultHandler viewResolutionResultHandler(@Qualifier(value="webFluxAdapterRegistry") ReactiveAdapterRegistry reactiveAdapterRegistry, @Qualifier(value="webFluxContentTypeResolver") RequestedContentTypeResolver contentTypeResolver) {
        ViewResolverRegistry registry = this.getViewResolverRegistry();
        List<ViewResolver> resolvers = registry.getViewResolvers();
        ViewResolutionResultHandler handler = new ViewResolutionResultHandler(resolvers, contentTypeResolver, reactiveAdapterRegistry);
        handler.setDefaultViews(registry.getDefaultViews());
        handler.setOrder(registry.getOrder());
        return handler;
    }

    @Bean
    public ServerResponseResultHandler serverResponseResultHandler(ServerCodecConfigurer serverCodecConfigurer) {
        List<ViewResolver> resolvers = this.getViewResolverRegistry().getViewResolvers();
        ServerResponseResultHandler handler = new ServerResponseResultHandler();
        handler.setMessageWriters(serverCodecConfigurer.getWriters());
        handler.setViewResolvers(resolvers);
        return handler;
    }

    protected final ViewResolverRegistry getViewResolverRegistry() {
        if (this.viewResolverRegistry == null) {
            this.viewResolverRegistry = new ViewResolverRegistry(this.applicationContext);
            this.configureViewResolvers(this.viewResolverRegistry);
        }
        return this.viewResolverRegistry;
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    private static final class NoUpgradeStrategyWebSocketService
    implements WebSocketService {
        private NoUpgradeStrategyWebSocketService() {
        }

        @Override
        public Mono<Void> handleRequest(ServerWebExchange exchange, WebSocketHandler webSocketHandler) {
            return Mono.error((Throwable)new IllegalStateException("No suitable RequestUpgradeStrategy"));
        }
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(@Nullable Object target, Errors errors) {
        }
    }

    private static final class EmptyHandlerMapping
    extends AbstractHandlerMapping {
        private EmptyHandlerMapping() {
        }

        public Mono<Object> getHandlerInternal(ServerWebExchange exchange) {
            return Mono.empty();
        }
    }
}

