/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.codec.DecodingException;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageReaderArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private static final Set<HttpMethod> SUPPORTED_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<HttpMessageReader<?>> messageReaders;
    private final List<MediaType> supportedMediaTypes;

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> readers) {
        this(readers, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> messageReaders, ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
        Assert.notEmpty(messageReaders, (String)"At least one HttpMessageReader is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.messageReaders = messageReaders;
        this.supportedMediaTypes = messageReaders.stream().flatMap(converter -> converter.getReadableMediaTypes().stream()).collect(Collectors.toList());
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    protected Mono<Object> readBody(MethodParameter bodyParameter, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange) {
        return this.readBody(bodyParameter, null, isBodyRequired, bindingContext, exchange);
    }

    protected Mono<Object> readBody(MethodParameter bodyParam, @Nullable MethodParameter actualParam, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange) {
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParam);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter((MethodParameter)actualParam) : bodyType;
        Class resolvedType = bodyType.resolve();
        ReactiveAdapter adapter = resolvedType != null ? this.getAdapterRegistry().getAdapter(resolvedType) : null;
        ResolvableType elementType = adapter != null ? bodyType.getGeneric(new int[0]) : bodyType;
        isBodyRequired = isBodyRequired || adapter != null && !adapter.supportsEmpty();
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        MediaType contentType2 = request.getHeaders().getContentType();
        MediaType mediaType = contentType2 != null ? contentType2 : MediaType.APPLICATION_OCTET_STREAM;
        for (HttpMessageReader<?> reader : this.getMessageReaders()) {
            Object[] hints;
            if (!reader.canRead(elementType, mediaType)) continue;
            Map readHints = Collections.emptyMap();
            if (adapter != null && adapter.isMultiValue()) {
                Object[] hints2;
                Flux flux = reader.read(actualType, elementType, request, response, readHints);
                flux = flux.onErrorResume(ex -> Flux.error((Throwable)this.handleReadError(bodyParam, (Throwable)ex)));
                if (isBodyRequired) {
                    flux = flux.switchIfEmpty((Publisher)Flux.defer(() -> Flux.error((Throwable)this.handleMissingBody(bodyParam))));
                }
                if ((hints2 = this.extractValidationHints(bodyParam)) != null) {
                    flux = flux.doOnNext(target -> this.validate(target, hints2, bodyParam, bindingContext, exchange));
                }
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            Mono mono = reader.readMono(actualType, elementType, request, response, readHints);
            mono = mono.onErrorResume(ex -> Mono.error((Throwable)this.handleReadError(bodyParam, (Throwable)ex)));
            if (isBodyRequired) {
                mono = mono.switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)this.handleMissingBody(bodyParam))));
            }
            if ((hints = this.extractValidationHints(bodyParam)) != null) {
                mono = mono.doOnNext(target -> this.validate(target, hints, bodyParam, bindingContext, exchange));
            }
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)mono)) : Mono.from((Publisher)mono);
        }
        HttpMethod method2 = request.getMethod();
        if (contentType2 == null && method2 != null && SUPPORTED_METHODS.contains(method2)) {
            Flux body2 = request.getBody().doOnNext(o -> {
                throw new UnsupportedMediaTypeStatusException(mediaType, this.supportedMediaTypes);
            });
            if (isBodyRequired) {
                body2 = body2.switchIfEmpty((Publisher)Mono.defer(() -> Mono.error((Throwable)this.handleMissingBody(bodyParam))));
            }
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)body2)) : Mono.from((Publisher)body2);
        }
        return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(mediaType, this.supportedMediaTypes));
    }

    private Throwable handleReadError(MethodParameter parameter, Throwable ex) {
        return ex instanceof DecodingException ? new ServerWebInputException("Failed to read HTTP message", parameter, ex) : ex;
    }

    private ServerWebInputException handleMissingBody(MethodParameter param) {
        return new ServerWebInputException("Request body is missing: " + param.getExecutable().toGenericString());
    }

    @Nullable
    private Object[] extractValidationHints(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            return objectArray;
        }
        return null;
    }

    private void validate(Object target, Object[] validationHints, MethodParameter param, BindingContext binding, ServerWebExchange exchange) {
        String name = Conventions.getVariableNameForParameter((MethodParameter)param);
        WebExchangeDataBinder binder = binding.createDataBinder(exchange, target, name);
        binder.validate(validationHints);
        if (binder.getBindingResult().hasErrors()) {
            throw new WebExchangeBindException(param, binder.getBindingResult());
        }
    }
}

