/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ServerRequest {
    @Nullable
    default public HttpMethod method() {
        return HttpMethod.resolve((String)this.methodName());
    }

    public String methodName();

    public URI uri();

    public UriBuilder uriBuilder();

    default public String path() {
        return this.uri().getRawPath();
    }

    default public PathContainer pathContainer() {
        return PathContainer.parsePath((String)this.path());
    }

    public Headers headers();

    public MultiValueMap<String, HttpCookie> cookies();

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1);

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1, Map<String, Object> var2);

    public <T> Mono<T> bodyToMono(Class<? extends T> var1);

    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> var1);

    public <T> Flux<T> bodyToFlux(Class<? extends T> var1);

    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> var1);

    default public Optional<Object> attribute(String name) {
        Map<String, Object> attributes = this.attributes();
        if (attributes.containsKey(name)) {
            return Optional.of(attributes.get(name));
        }
        return Optional.empty();
    }

    public Map<String, Object> attributes();

    default public Optional<String> queryParam(String name) {
        List queryParamValues = (List)this.queryParams().get((Object)name);
        if (CollectionUtils.isEmpty((Collection)queryParamValues)) {
            return Optional.empty();
        }
        String value = (String)queryParamValues.get(0);
        if (value == null) {
            value = "";
        }
        return Optional.of(value);
    }

    public MultiValueMap<String, String> queryParams();

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return this.pathVariables().get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
    }

    public Map<String, String> pathVariables();

    public Mono<WebSession> session();

    public Mono<? extends Principal> principal();

    public static ServerRequest create(ServerWebExchange exchange, List<HttpMessageReader<?>> messageReaders) {
        return new DefaultServerRequest(exchange, messageReaders);
    }

    public static interface Headers {
        public List<MediaType> accept();

        public List<Charset> acceptCharset();

        public List<Locale.LanguageRange> acceptLanguage();

        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        @Nullable
        public InetSocketAddress host();

        public List<HttpRange> range();

        public List<String> header(String var1);

        public HttpHeaders asHttpHeaders();
    }
}

