/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;

public class ServletServerHttpResponse
implements ServerHttpResponse {
    private final HttpServletResponse servletResponse;
    private final HttpHeaders headers = new HttpHeaders();
    private boolean headersWritten = false;

    public ServletServerHttpResponse(HttpServletResponse servletResponse) {
        Assert.notNull((Object)servletResponse, (String)"'servletResponse' must not be null");
        this.servletResponse = servletResponse;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setStatusCode(HttpStatus status) {
        this.servletResponse.setStatus(status.value());
    }

    public HttpHeaders getHeaders() {
        return this.headersWritten ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
    }

    public OutputStream getBody() throws IOException {
        this.writeHeaders();
        return this.servletResponse.getOutputStream();
    }

    public void close() {
        this.writeHeaders();
    }

    private void writeHeaders() {
        if (!this.headersWritten) {
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                String headerName = entry.getKey();
                for (String headerValue : entry.getValue()) {
                    this.servletResponse.addHeader(headerName, headerValue);
                }
            }
            if (this.servletResponse.getContentType() == null && this.headers.getContentType() != null) {
                this.servletResponse.setContentType(this.headers.getContentType().toString());
            }
            if (this.servletResponse.getCharacterEncoding() == null && this.headers.getContentType() != null && this.headers.getContentType().getCharSet() != null) {
                this.servletResponse.setCharacterEncoding(this.headers.getContentType().getCharSet().name());
            }
            this.headersWritten = true;
        }
    }
}

