/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class UriUtils {
    public static String encodeUri(String uri, String encoding) throws UnsupportedEncodingException {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(uri).build();
        UriComponents encoded = uriComponents.encode(encoding);
        return encoded.toUriString();
    }

    public static String encodeHttpUrl(String httpUrl, String encoding) throws UnsupportedEncodingException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl(httpUrl).build();
        UriComponents encoded = uriComponents.encode(encoding);
        return encoded.toUriString();
    }

    public static String encodeUriComponents(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String encoding) throws UnsupportedEncodingException {
        int portAsInt = port != null ? Integer.parseInt(port) : -1;
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        builder.scheme(scheme).userInfo(userInfo).host(host).port(portAsInt);
        builder.path(path).query(query).fragment(fragment);
        UriComponents encoded = builder.build().encode(encoding);
        return encoded.toUriString();
    }

    public static String encodeScheme(String scheme, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(scheme, encoding, UriComponents.Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(authority, encoding, UriComponents.Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(userInfo, encoding, UriComponents.Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(host, encoding, UriComponents.Type.HOST);
    }

    public static String encodePort(String port, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(port, encoding, UriComponents.Type.PORT);
    }

    public static String encodePath(String path, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(path, encoding, UriComponents.Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(segment, encoding, UriComponents.Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(query, encoding, UriComponents.Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(queryParam, encoding, UriComponents.Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) throws UnsupportedEncodingException {
        return UriComponents.encodeUriComponent(fragment, encoding, UriComponents.Type.FRAGMENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String source, String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        int i = 0;
        while (i < length) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 >= length) throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                char hex1 = source.charAt(i + 1);
                char hex2 = source.charAt(i + 2);
                int u = Character.digit(hex1, 16);
                int l = Character.digit(hex2, 16);
                if (u == -1 || l == -1) {
                    throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                }
                bos.write((char)((u << 4) + l));
                i += 2;
                changed = true;
            } else {
                bos.write(ch);
            }
            ++i;
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }
}

