/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class JdbcTestUtils {
    private static final Log logger = LogFactory.getLog(JdbcTestUtils.class);

    public static int countRowsInTable(JdbcOperations jdbcTemplate, String tableName) {
        return JdbcTestUtils.countRowsInTable(JdbcClient.create((JdbcOperations)jdbcTemplate), tableName);
    }

    public static int countRowsInTable(JdbcClient jdbcClient, String tableName) {
        return JdbcTestUtils.countRowsInTableWhere(jdbcClient, tableName, null);
    }

    public static int countRowsInTableWhere(JdbcOperations jdbcTemplate, String tableName, @Nullable String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere(JdbcClient.create((JdbcOperations)jdbcTemplate), tableName, whereClause);
    }

    public static int countRowsInTableWhere(JdbcClient jdbcClient, String tableName, @Nullable String whereClause) {
        String sql = "SELECT COUNT(0) FROM " + tableName;
        if (StringUtils.hasText((String)whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        return (Integer)jdbcClient.sql(sql).query(Integer.class).single();
    }

    public static int deleteFromTables(JdbcOperations jdbcTemplate, String ... tableNames) {
        return JdbcTestUtils.deleteFromTables(JdbcClient.create((JdbcOperations)jdbcTemplate), tableNames);
    }

    public static int deleteFromTables(JdbcClient jdbcClient, String ... tableNames) {
        int totalRowCount = 0;
        for (String tableName : tableNames) {
            int rowCount = jdbcClient.sql("DELETE FROM " + tableName).update();
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Deleted " + rowCount + " rows from table " + tableName));
        }
        return totalRowCount;
    }

    public static int deleteFromTableWhere(JdbcOperations jdbcTemplate, String tableName, String whereClause, Object ... args) {
        return JdbcTestUtils.deleteFromTableWhere(JdbcClient.create((JdbcOperations)jdbcTemplate), tableName, whereClause, args);
    }

    public static int deleteFromTableWhere(JdbcClient jdbcClient, String tableName, String whereClause, Object ... args) {
        String sql = "DELETE FROM " + tableName;
        if (StringUtils.hasText((String)whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        int rowCount = jdbcClient.sql(sql).params(args).update();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Deleted " + rowCount + " rows from table " + tableName));
        }
        return rowCount;
    }

    public static void dropTables(JdbcOperations jdbcTemplate, String ... tableNames) {
        JdbcTestUtils.dropTables(JdbcClient.create((JdbcOperations)jdbcTemplate), tableNames);
    }

    public static void dropTables(JdbcClient jdbcClient, String ... tableNames) {
        for (String tableName : tableNames) {
            jdbcClient.sql("DROP TABLE " + tableName).update();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Dropped table " + tableName));
        }
    }
}

