/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.ActiveProfilesUtils;
import org.springframework.test.context.support.ApplicationContextInitializerUtils;
import org.springframework.test.context.support.ContextLoaderUtils;
import org.springframework.test.context.support.DefaultTestContext;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTestContextBootstrapper
implements TestContextBootstrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private BootstrapContext bootstrapContext;

    @Override
    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        Assert.state((this.bootstrapContext != null ? 1 : 0) != 0, (String)"No BootstrapContext set");
        return this.bootstrapContext;
    }

    @Override
    public TestContext buildTestContext() {
        return new DefaultTestContext(this.getBootstrapContext().getTestClass(), this.buildMergedContextConfiguration(), this.getCacheAwareContextLoaderDelegate());
    }

    @Override
    public final List<TestExecutionListener> getTestExecutionListeners() {
        Class<?> clazz = this.getBootstrapContext().getTestClass();
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Class<? extends TestExecutionListener>> classesList = new ArrayList<Class<? extends TestExecutionListener>>();
        boolean usingDefaults = false;
        TestContextAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        if (descriptor == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("@TestExecutionListeners is not present for class [%s]: using defaults.", clazz.getName()));
            }
            usingDefaults = true;
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                TestExecutionListeners testExecutionListeners = descriptor.getAnnotation();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Retrieved @TestExecutionListeners [%s] for declaring class [%s].", testExecutionListeners, declaringClass.getName()));
                }
                boolean inheritListeners = testExecutionListeners.inheritListeners();
                TestContextAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> parentDescriptor = descriptor.next();
                if (!(inheritListeners && parentDescriptor != null || testExecutionListeners.mergeMode() != TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)String.format("Merging default listeners with listeners configured via @TestExecutionListeners for class [%s].", descriptor.getRootDeclaringClass().getName()));
                    }
                    usingDefaults = true;
                    classesList.addAll(this.getDefaultTestExecutionListenerClasses());
                }
                classesList.addAll(0, Arrays.asList(testExecutionListeners.listeners()));
                descriptor = inheritListeners ? parentDescriptor : null;
            }
        }
        AbstractCollection classesToUse = classesList;
        if (usingDefaults) {
            classesToUse = new LinkedHashSet<Class<? extends TestExecutionListener>>(classesList);
        }
        List<TestExecutionListener> listeners = this.instantiateListeners(classesToUse);
        if (usingDefaults) {
            AnnotationAwareOrderComparator.sort(listeners);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using TestExecutionListeners: " + listeners));
        }
        return listeners;
    }

    private List<TestExecutionListener> instantiateListeners(Collection<Class<? extends TestExecutionListener>> classes) {
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(classes.size());
        for (Class<? extends TestExecutionListener> listenerClass : classes) {
            try {
                listeners.add((TestExecutionListener)BeanUtils.instantiateClass(listenerClass));
            }
            catch (BeanInstantiationException ex) {
                if (ex.getCause() instanceof NoClassDefFoundError) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)String.format("Skipping candidate TestExecutionListener [%s] due to a missing dependency. Specify custom listener classes or make the default listener classes and their required dependencies available. Offending class: [%s]", listenerClass.getName(), ex.getCause().getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return listeners;
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (String className : this.getDefaultTestExecutionListenerClassNames()) {
            try {
                defaultListenerClasses.add(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            catch (Throwable ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."), ex);
            }
        }
        return defaultListenerClasses;
    }

    protected List<String> getDefaultTestExecutionListenerClassNames() {
        List classNames = SpringFactoriesLoader.loadFactoryNames(TestExecutionListener.class, (ClassLoader)this.getClass().getClassLoader());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Loaded default TestExecutionListener class names from location [%s]: %s", "META-INF/spring.factories", classNames));
        }
        return Collections.unmodifiableList(classNames);
    }

    @Override
    public final MergedContextConfiguration buildMergedContextConfiguration() {
        Class<?> testClass = this.getBootstrapContext().getTestClass();
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = this.getCacheAwareContextLoaderDelegate();
        if (TestContextAnnotationUtils.findAnnotationDescriptorForTypes(testClass, ContextConfiguration.class, ContextHierarchy.class) == null) {
            return this.buildDefaultMergedContextConfiguration(testClass, cacheAwareContextLoaderDelegate);
        }
        if (TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ContextHierarchy.class) != null) {
            Map<String, List<ContextConfigurationAttributes>> hierarchyMap = ContextLoaderUtils.buildContextHierarchyMap(testClass);
            MergedContextConfiguration parentConfig = null;
            MergedContextConfiguration mergedConfig = null;
            for (List<ContextConfigurationAttributes> list : hierarchyMap.values()) {
                ArrayList<ContextConfigurationAttributes> reversedList = new ArrayList<ContextConfigurationAttributes>(list);
                Collections.reverse(reversedList);
                Assert.notEmpty(reversedList, (String)"ContextConfigurationAttributes list must not be empty");
                Class<?> declaringClass = ((ContextConfigurationAttributes)reversedList.get(0)).getDeclaringClass();
                parentConfig = mergedConfig = this.buildMergedContextConfiguration(declaringClass, reversedList, parentConfig, cacheAwareContextLoaderDelegate, true);
            }
            Assert.state((mergedConfig != null ? 1 : 0) != 0, (String)"No merged context configuration");
            return mergedConfig;
        }
        return this.buildMergedContextConfiguration(testClass, ContextLoaderUtils.resolveContextConfigurationAttributes(testClass), null, cacheAwareContextLoaderDelegate, true);
    }

    private MergedContextConfiguration buildDefaultMergedContextConfiguration(Class<?> testClass, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        List<ContextConfigurationAttributes> defaultConfigAttributesList = Collections.singletonList(new ContextConfigurationAttributes(testClass));
        ContextLoader contextLoader = this.resolveContextLoader(testClass, defaultConfigAttributesList);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s], using %s", testClass.getName(), contextLoader.getClass().getSimpleName()));
        }
        return this.buildMergedContextConfiguration(testClass, defaultConfigAttributesList, null, cacheAwareContextLoaderDelegate, false);
    }

    private MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, @Nullable MergedContextConfiguration parentConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, boolean requireLocationsClassesOrInitializers) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be null or empty");
        ContextLoader contextLoader = this.resolveContextLoader(testClass, configAttributesList);
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList classes = new ArrayList();
        ArrayList initializers = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locations.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classes.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locations.addAll(0, Arrays.asList(processedLocations));
            }
            initializers.addAll(0, Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        Set<ContextCustomizer> contextCustomizers = this.getContextCustomizers(testClass, Collections.unmodifiableList(configAttributesList));
        Assert.state((!requireLocationsClassesOrInitializers || !AbstractTestContextBootstrapper.areAllEmpty(locations, classes, initializers, contextCustomizers) ? 1 : 0) != 0, () -> String.format("%s was unable to detect defaults, and no ApplicationContextInitializers or ContextCustomizers were declared for context configuration attributes %s", contextLoader.getClass().getSimpleName(), configAttributesList));
        MergedTestPropertySources mergedTestPropertySources = TestPropertySourceUtils.buildMergedTestPropertySources(testClass);
        MergedContextConfiguration mergedConfig = new MergedContextConfiguration(testClass, StringUtils.toStringArray(locations), ClassUtils.toClassArray(classes), ApplicationContextInitializerUtils.resolveInitializerClasses(configAttributesList), ActiveProfilesUtils.resolveActiveProfiles(testClass), mergedTestPropertySources.getLocations(), mergedTestPropertySources.getProperties(), contextCustomizers, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
        return this.processMergedContextConfiguration(mergedConfig);
    }

    private Set<ContextCustomizer> getContextCustomizers(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        List<ContextCustomizerFactory> factories = this.getContextCustomizerFactories();
        LinkedHashSet<ContextCustomizer> customizers = new LinkedHashSet<ContextCustomizer>(factories.size());
        for (ContextCustomizerFactory factory : factories) {
            ContextCustomizer customizer = factory.createContextCustomizer(testClass, configAttributes);
            if (customizer == null) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    protected List<ContextCustomizerFactory> getContextCustomizerFactories() {
        return SpringFactoriesLoader.loadFactories(ContextCustomizerFactory.class, (ClassLoader)this.getClass().getClassLoader());
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notNull(configAttributesList, (String)"ContextConfigurationAttributes list must not be null");
        Class<? extends ContextLoader> contextLoaderClass = this.resolveExplicitContextLoaderClass(configAttributesList);
        if (contextLoaderClass == null) {
            contextLoaderClass = this.getDefaultContextLoaderClass(testClass);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Using ContextLoader class [%s] for test class [%s]", contextLoaderClass.getName(), testClass.getName()));
        }
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    @Nullable
    protected Class<? extends ContextLoader> resolveExplicitContextLoaderClass(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(configAttributesList, (String)"ContextConfigurationAttributes list must not be null");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Resolving ContextLoader for context configuration attributes %s", configAttributes));
            }
            if (ContextLoader.class == (contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Found explicit ContextLoader class [%s] for context configuration attributes %s", contextLoaderClass.getName(), configAttributes));
            }
            return contextLoaderClass;
        }
        return null;
    }

    protected CacheAwareContextLoaderDelegate getCacheAwareContextLoaderDelegate() {
        return this.getBootstrapContext().getCacheAwareContextLoaderDelegate();
    }

    protected abstract Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> var1);

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        return mergedConfig;
    }

    private static boolean areAllEmpty(Collection<?> ... collections) {
        return Arrays.stream(collections).allMatch(Collection::isEmpty);
    }
}

