/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public ResultMatcher asyncStarted() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                RequestResultMatchers.assertAsyncStarted(request);
            }
        };
    }

    public ResultMatcher asyncNotStarted() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                AssertionErrors.assertEquals("Async started", false, request.isAsyncStarted());
            }
        };
    }

    public <T> ResultMatcher asyncResult(final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                RequestResultMatchers.assertAsyncStarted(request);
                MatcherAssert.assertThat((String)"Async result", (Object)result.getAsyncResult(), (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher asyncResult(final Object expectedResult) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                RequestResultMatchers.assertAsyncStarted(request);
                AssertionErrors.assertEquals("Async result", expectedResult, result.getAsyncResult());
            }
        };
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Object value = result.getRequest().getAttribute(name);
                MatcherAssert.assertThat((String)("Request attribute '" + name + "'"), (Object)value, (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(final String name, final Object expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Request attribute '" + name + "'", expectedValue, result.getRequest().getAttribute(name));
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Object value = result.getRequest().getSession().getAttribute(name);
                MatcherAssert.assertThat((String)("Session attribute '" + name + "'"), (Object)value, (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Object value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Session attribute '" + name + "'", value, result.getRequest().getSession().getAttribute(name));
            }
        };
    }

    private static void assertAsyncStarted(HttpServletRequest request) {
        AssertionErrors.assertEquals("Async started", true, request.isAsyncStarted());
    }
}

