/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.annotation.support;

import io.rsocket.frame.FrameType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.AbstractMessageCondition;
import org.springframework.util.Assert;

public class RSocketFrameTypeMessageCondition
extends AbstractMessageCondition<RSocketFrameTypeMessageCondition> {
    public static final String FRAME_TYPE_HEADER = "rsocketFrameType";
    private static final Map<String, RSocketFrameTypeMessageCondition> frameTypeConditionCache = new HashMap<String, RSocketFrameTypeMessageCondition>(FrameType.values().length);
    private final Set<FrameType> frameTypes;
    public static final RSocketFrameTypeMessageCondition CONNECT_CONDITION;
    public static final RSocketFrameTypeMessageCondition REQUEST_CONDITION;

    public RSocketFrameTypeMessageCondition(FrameType ... frameType) {
        this(Arrays.asList(frameType));
    }

    public RSocketFrameTypeMessageCondition(Collection<FrameType> frameTypes) {
        Assert.notEmpty(frameTypes, (String)"`frameTypes` are required");
        this.frameTypes = Collections.unmodifiableSet(new LinkedHashSet<FrameType>(frameTypes));
    }

    public Set<FrameType> getFrameTypes() {
        return this.frameTypes;
    }

    @Override
    protected Collection<?> getContent() {
        return this.frameTypes;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Nullable
    public static FrameType getFrameType(Message<?> message) {
        return (FrameType)message.getHeaders().get(FRAME_TYPE_HEADER);
    }

    @Override
    public RSocketFrameTypeMessageCondition combine(RSocketFrameTypeMessageCondition other) {
        if (this.frameTypes.equals(other.frameTypes)) {
            return other;
        }
        LinkedHashSet<FrameType> set = new LinkedHashSet<FrameType>(this.frameTypes);
        set.addAll(other.frameTypes);
        return new RSocketFrameTypeMessageCondition(set);
    }

    @Override
    public RSocketFrameTypeMessageCondition getMatchingCondition(Message<?> message) {
        FrameType actual = message.getHeaders().get(FRAME_TYPE_HEADER, FrameType.class);
        if (actual != null) {
            for (FrameType type : this.frameTypes) {
                if (actual != type) continue;
                return frameTypeConditionCache.get(type.name());
            }
        }
        return null;
    }

    @Override
    public int compareTo(RSocketFrameTypeMessageCondition other, Message<?> message) {
        return other.frameTypes.size() - this.frameTypes.size();
    }

    static {
        for (FrameType type : FrameType.values()) {
            frameTypeConditionCache.put(type.name(), new RSocketFrameTypeMessageCondition(type));
        }
        CONNECT_CONDITION = new RSocketFrameTypeMessageCondition(FrameType.SETUP, FrameType.METADATA_PUSH);
        REQUEST_CONDITION = new RSocketFrameTypeMessageCondition(FrameType.REQUEST_FNF, FrameType.REQUEST_RESPONSE, FrameType.REQUEST_STREAM, FrameType.REQUEST_CHANNEL);
    }
}

