/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageMappingInfo;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageTypeMessageCondition;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.messaging.simp.annotation.support.SendToMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.SubscriptionMethodReturnValueHandler;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class SimpAnnotationMethodMessageHandler
extends AbstractMethodMessageHandler<SimpMessageMappingInfo>
implements SmartLifecycle {
    private final SubscribableChannel clientInboundChannel;
    private final SimpMessageSendingOperations clientMessagingTemplate;
    private final SimpMessageSendingOperations brokerTemplate;
    private MessageConverter messageConverter;
    private ConversionService conversionService = new DefaultFormattingConversionService();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Validator validator;
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    public SimpAnnotationMethodMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, SimpMessageSendingOperations brokerTemplate) {
        Assert.notNull((Object)clientInboundChannel, (String)"clientInboundChannel must not be null");
        Assert.notNull((Object)clientOutboundChannel, (String)"clientOutboundChannel must not be null");
        Assert.notNull((Object)brokerTemplate, (String)"brokerTemplate must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.clientMessagingTemplate = new SimpMessagingTemplate(clientOutboundChannel);
        this.brokerTemplate = brokerTemplate;
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        converters.add(new StringMessageConverter());
        converters.add(new ByteArrayMessageConverter());
        this.messageConverter = new CompositeMessageConverter(converters);
    }

    public void setMessageConverter(MessageConverter converter) {
        this.messageConverter = converter;
        if (converter != null) {
            ((AbstractMessageSendingTemplate)((Object)this.clientMessagingTemplate)).setMessageConverter(converter);
        }
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        ConfigurableListableBeanFactory beanFactory = ClassUtils.isAssignableValue(ConfigurableApplicationContext.class, (Object)this.getApplicationContext()) ? ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory() : null;
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new DestinationVariableMethodArgumentResolver(this.conversionService));
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver());
        resolvers.addAll(this.getCustomArgumentResolvers());
        resolvers.add(new PayloadArgumentResolver(this.messageConverter, (Validator)(this.validator != null ? this.validator : new NoOpValidator())));
        return resolvers;
    }

    @Override
    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>();
        handlers.add(new SendToMethodReturnValueHandler(this.brokerTemplate, true));
        handlers.add(new SubscriptionMethodReturnValueHandler(this.clientMessagingTemplate));
        handlers.addAll(this.getCustomReturnValueHandlers());
        handlers.add(new SendToMethodReturnValueHandler(this.brokerTemplate, false));
        return handlers;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null;
    }

    @Override
    protected SimpMessageMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        MessageMapping typeAnnot = (MessageMapping)AnnotationUtils.findAnnotation(handlerType, MessageMapping.class);
        MessageMapping messageAnnot = (MessageMapping)AnnotationUtils.findAnnotation((Method)method, MessageMapping.class);
        if (messageAnnot != null) {
            SimpMessageMappingInfo result = this.createMessageMappingCondition(messageAnnot);
            if (typeAnnot != null) {
                result = this.createMessageMappingCondition(typeAnnot).combine(result);
            }
            return result;
        }
        SubscribeMapping subsribeAnnot = (SubscribeMapping)AnnotationUtils.findAnnotation((Method)method, SubscribeMapping.class);
        if (subsribeAnnot != null) {
            SimpMessageMappingInfo result = this.createSubscribeCondition(subsribeAnnot);
            if (typeAnnot != null) {
                result = this.createMessageMappingCondition(typeAnnot).combine(result);
            }
            return result;
        }
        return null;
    }

    private SimpMessageMappingInfo createMessageMappingCondition(MessageMapping annotation) {
        return new SimpMessageMappingInfo(SimpMessageTypeMessageCondition.MESSAGE, new DestinationPatternsMessageCondition(annotation.value()));
    }

    private SimpMessageMappingInfo createSubscribeCondition(SubscribeMapping annotation) {
        return new SimpMessageMappingInfo(SimpMessageTypeMessageCondition.SUBSCRIBE, new DestinationPatternsMessageCondition(annotation.value()));
    }

    @Override
    protected Set<String> getDirectLookupDestinations(SimpMessageMappingInfo mapping) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String pattern : mapping.getDestinationConditions().getPatterns()) {
            if (this.pathMatcher.isPattern(pattern)) continue;
            result.add(pattern);
        }
        return result;
    }

    @Override
    protected String getDestination(Message<?> message) {
        return (String)message.getHeaders().get("simpDestination");
    }

    @Override
    protected SimpMessageMappingInfo getMatchingMapping(SimpMessageMappingInfo mapping, Message<?> message) {
        return mapping.getMatchingCondition((Message)message);
    }

    @Override
    protected Comparator<SimpMessageMappingInfo> getMappingComparator(final Message<?> message) {
        return new Comparator<SimpMessageMappingInfo>(){

            @Override
            public int compare(SimpMessageMappingInfo info1, SimpMessageMappingInfo info2) {
                return info1.compareTo(info2, message);
            }
        };
    }

    @Override
    protected void handleMatch(SimpMessageMappingInfo mapping, HandlerMethod handlerMethod, String lookupDestination, Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        String matchedPattern = mapping.getDestinationConditions().getPatterns().iterator().next();
        Map vars = this.getPathMatcher().extractUriTemplateVariables(matchedPattern, lookupDestination);
        headers.setHeader(DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER, vars);
        message = MessageBuilder.withPayload(message.getPayload()).setHeaders(headers).build();
        super.handleMatch(mapping, handlerMethod, lookupDestination, message);
    }

    @Override
    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    }
}

