/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public abstract class AbstractMessageConverter
implements MessageConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<MimeType> supportedMimeTypes;
    private Class<?> serializedPayloadClass = byte[].class;
    private ContentTypeResolver contentTypeResolver;

    protected AbstractMessageConverter(MimeType supportedMimeType) {
        this.supportedMimeTypes = Collections.singletonList(supportedMimeType);
    }

    protected AbstractMessageConverter(Collection<MimeType> supportedMimeTypes) {
        Assert.notNull(supportedMimeTypes, (String)"SupportedMimeTypes must not be null");
        this.supportedMimeTypes = new ArrayList<MimeType>(supportedMimeTypes);
    }

    public List<MimeType> getSupportedMimeTypes() {
        return Collections.unmodifiableList(this.supportedMimeTypes);
    }

    public void setContentTypeResolver(ContentTypeResolver resolver) {
        this.contentTypeResolver = resolver;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setSerializedPayloadClass(Class<?> payloadClass) {
        Assert.isTrue((byte[].class.equals(payloadClass) || String.class.equals(payloadClass) ? 1 : 0) != 0, (String)("Payload class must be byte[] or String: " + payloadClass));
        this.serializedPayloadClass = payloadClass;
    }

    public Class<?> getSerializedPayloadClass() {
        return this.serializedPayloadClass;
    }

    protected MimeType getDefaultContentType(Object payload) {
        List<MimeType> mimeTypes = this.getSupportedMimeTypes();
        return !mimeTypes.isEmpty() ? mimeTypes.get(0) : null;
    }

    protected abstract boolean supports(Class<?> var1);

    @Override
    public final Object fromMessage(Message<?> message, Class<?> targetClass) {
        if (!this.canConvertFrom(message, targetClass)) {
            return null;
        }
        return this.convertFromInternal(message, targetClass);
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass) && this.supportsMimeType(message.getHeaders());
    }

    public abstract Object convertFromInternal(Message<?> var1, Class<?> var2);

    @Override
    public final Message<?> toMessage(Object payload, MessageHeaders headers) {
        MimeType mimeType;
        if (!this.canConvertTo(payload, headers)) {
            return null;
        }
        payload = this.convertToInternal(payload, headers);
        MessageBuilder<Object> builder = MessageBuilder.withPayload(payload);
        if (headers != null) {
            builder.copyHeaders(headers);
        }
        if ((mimeType = this.getDefaultContentType(payload)) != null) {
            builder.setHeaderIfAbsent("contentType", mimeType);
        }
        return builder.build();
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        Class<?> clazz = payload != null ? payload.getClass() : null;
        return this.supports(clazz) && this.supportsMimeType(headers);
    }

    public abstract Object convertToInternal(Object var1, MessageHeaders var2);

    protected boolean supportsMimeType(MessageHeaders headers) {
        MimeType mimeType = this.getMimeType(headers);
        if (mimeType == null) {
            return true;
        }
        if (this.getSupportedMimeTypes().isEmpty()) {
            return true;
        }
        for (MimeType supported : this.getSupportedMimeTypes()) {
            if (!supported.getType().equals(mimeType.getType()) || !supported.getSubtype().equals(mimeType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    protected MimeType getMimeType(MessageHeaders headers) {
        return this.contentTypeResolver != null ? this.contentTypeResolver.resolve(headers) : null;
    }
}

