/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DriverManagerDataSource
extends AbstractDataSource {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private Properties connectionProperties;

    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String driverClassName, String url, String username, String password) throws CannotGetJdbcConnectionException {
        this.setDriverClassName(driverClassName);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public DriverManagerDataSource(String url, String username, String password) throws CannotGetJdbcConnectionException {
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public DriverManagerDataSource(String url) throws CannotGetJdbcConnectionException {
        this.setUrl(url);
    }

    public void setDriverClassName(String driverClassName) throws CannotGetJdbcConnectionException {
        Assert.hasText((String)driverClassName, (String)"Property 'driverClassName' must not be empty");
        this.driverClassName = driverClassName.trim();
        try {
            Class.forName(this.driverClassName, true, ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotGetJdbcConnectionException("Could not load JDBC driver class [" + this.driverClassName + "]", ex);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loaded JDBC driver: " + this.driverClassName));
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String url) {
        Assert.hasText((String)url, (String)"Property 'url' must not be empty");
        this.url = url.trim();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriverManager();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriverManager(username, password);
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return this.getConnectionFromDriverManager(this.getUsername(), this.getPassword());
    }

    protected Connection getConnectionFromDriverManager(String username, String password) throws SQLException {
        Properties props = new Properties(this.getConnectionProperties());
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        return this.getConnectionFromDriverManager(this.getUrl(), props);
    }

    protected Connection getConnectionFromDriverManager(String url, Properties props) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new JDBC Connection to [" + url + "]"));
        }
        return DriverManager.getConnection(url, props);
    }
}

