/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.scheduling.support.ScheduledTaskObservationContext;
import org.springframework.scheduling.support.ScheduledTaskObservationConvention;
import org.springframework.scheduling.support.ScheduledTaskObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultScheduledTaskObservationConvention
implements ScheduledTaskObservationConvention {
    private static final String DEFAULT_NAME = "tasks.scheduled.execution";
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OUTCOME_SUCCESS = KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue OUTCOME_ERROR = KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"ERROR");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(ScheduledTaskObservationContext context) {
        return "task " + StringUtils.uncapitalize((String)context.getTargetClass().getSimpleName()) + "." + context.getMethod().getName();
    }

    public KeyValues getLowCardinalityKeyValues(ScheduledTaskObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.codeFunction(context), this.codeNamespace(context), this.exception(context), this.outcome(context)});
    }

    protected KeyValue codeFunction(ScheduledTaskObservationContext context) {
        return KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.CODE_FUNCTION, (String)context.getMethod().getName());
    }

    protected KeyValue codeNamespace(ScheduledTaskObservationContext context) {
        return KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.CODE_NAMESPACE, (String)context.getTargetClass().getCanonicalName());
    }

    protected KeyValue exception(ScheduledTaskObservationContext context) {
        if (context.getError() != null) {
            return KeyValue.of((KeyName)ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)context.getError().getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ScheduledTaskObservationContext context) {
        if (context.getError() != null) {
            return OUTCOME_ERROR;
        }
        if (!context.isComplete()) {
            return OUTCOME_UNKNOWN;
        }
        return OUTCOME_SUCCESS;
    }
}

