/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierAnnotationAutowireCandidateResolver
implements AutowireCandidateResolver,
BeanFactoryAware {
    private final Set<Class<? extends Annotation>> qualifierTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private Class<? extends Annotation> valueAnnotationType = Value.class;
    private BeanFactory beanFactory;

    public QualifierAnnotationAutowireCandidateResolver() {
        this.qualifierTypes.add(Qualifier.class);
        try {
            this.qualifierTypes.add(ClassUtils.forName((String)"javax.inject.Qualifier", (ClassLoader)QualifierAnnotationAutowireCandidateResolver.class.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public QualifierAnnotationAutowireCandidateResolver(Class<? extends Annotation> qualifierType) {
        Assert.notNull(qualifierType, (String)"'qualifierType' must not be null");
        this.qualifierTypes.add(qualifierType);
    }

    public QualifierAnnotationAutowireCandidateResolver(Set<Class<? extends Annotation>> qualifierTypes) {
        Assert.notNull(qualifierTypes, (String)"'qualifierTypes' must not be null");
        this.qualifierTypes.addAll(qualifierTypes);
    }

    public void addQualifierType(Class<? extends Annotation> qualifierType) {
        this.qualifierTypes.add(qualifierType);
    }

    public void setValueAnnotationType(Class<? extends Annotation> valueAnnotationType) {
        this.valueAnnotationType = valueAnnotationType;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        Method method;
        MethodParameter methodParam;
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        if (descriptor == null) {
            return true;
        }
        boolean match = this.checkQualifiers(bdHolder, descriptor.getAnnotations());
        if (match && (methodParam = descriptor.getMethodParameter()) != null && ((method = methodParam.getMethod()) == null || Void.TYPE.equals(method.getReturnType()))) {
            match = this.checkQualifiers(bdHolder, methodParam.getMethodAnnotations());
        }
        return match;
    }

    protected boolean checkQualifiers(BeanDefinitionHolder bdHolder, Annotation[] annotationsToSearch) {
        if (ObjectUtils.isEmpty((Object[])annotationsToSearch)) {
            return true;
        }
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        for (Annotation annotation : annotationsToSearch) {
            Class<? extends Annotation> type = annotation.annotationType();
            boolean checkMeta = true;
            boolean fallbackToMeta = false;
            if (this.isQualifier(type)) {
                if (!this.checkQualifier(bdHolder, annotation, typeConverter)) {
                    fallbackToMeta = true;
                } else {
                    checkMeta = false;
                }
            }
            if (!checkMeta) continue;
            boolean foundMeta = false;
            for (Annotation metaAnn : type.getAnnotations()) {
                Class<? extends Annotation> metaType = metaAnn.annotationType();
                if (!this.isQualifier(metaType)) continue;
                foundMeta = true;
                if ((!fallbackToMeta || !StringUtils.isEmpty((Object)AnnotationUtils.getValue((Annotation)metaAnn))) && this.checkQualifier(bdHolder, metaAnn, typeConverter)) continue;
                return false;
            }
            if (!fallbackToMeta || foundMeta) continue;
            return false;
        }
        return true;
    }

    protected boolean isQualifier(Class<? extends Annotation> annotationType) {
        for (Class<? extends Annotation> qualifierType : this.qualifierTypes) {
            if (!annotationType.equals(qualifierType) && !annotationType.isAnnotationPresent(qualifierType)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkQualifier(BeanDefinitionHolder bdHolder, Annotation annotation, TypeConverter typeConverter) {
        Map attributes;
        Class<? extends Annotation> type = annotation.annotationType();
        RootBeanDefinition bd = (RootBeanDefinition)bdHolder.getBeanDefinition();
        AutowireCandidateQualifier qualifier = bd.getQualifier(type.getName());
        if (qualifier == null) {
            qualifier = bd.getQualifier(ClassUtils.getShortName(type));
        }
        if (qualifier == null) {
            RootBeanDefinition dbd;
            Annotation targetAnnotation = this.getFactoryMethodAnnotation(bd, type);
            if (targetAnnotation == null && (dbd = this.getResolvedDecoratedDefinition(bd)) != null) {
                targetAnnotation = this.getFactoryMethodAnnotation(dbd, type);
            }
            if (targetAnnotation == null) {
                if (this.beanFactory != null) {
                    try {
                        Class<?> beanType = this.beanFactory.getType(bdHolder.getBeanName());
                        if (beanType != null) {
                            targetAnnotation = AnnotationUtils.getAnnotation((AnnotatedElement)ClassUtils.getUserClass(beanType), type);
                        }
                    }
                    catch (NoSuchBeanDefinitionException ex) {
                        // empty catch block
                    }
                }
                if (targetAnnotation == null && bd.hasBeanClass()) {
                    targetAnnotation = AnnotationUtils.getAnnotation((AnnotatedElement)ClassUtils.getUserClass(bd.getBeanClass()), type);
                }
            }
            if (targetAnnotation != null && targetAnnotation.equals(annotation)) {
                return true;
            }
        }
        if ((attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation)).isEmpty() && qualifier == null) {
            return false;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            Object expectedValue = entry.getValue();
            Object actualValue = null;
            if (qualifier != null) {
                actualValue = qualifier.getAttribute(attributeName);
            }
            if (actualValue == null) {
                actualValue = bd.getAttribute(attributeName);
            }
            if (actualValue == null && attributeName.equals(AutowireCandidateQualifier.VALUE_KEY) && expectedValue instanceof String && bdHolder.matchesName((String)expectedValue)) continue;
            if (actualValue == null && qualifier != null) {
                actualValue = AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName);
            }
            if (actualValue != null) {
                actualValue = typeConverter.convertIfNecessary(actualValue, expectedValue.getClass());
            }
            if (expectedValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }

    protected RootBeanDefinition getResolvedDecoratedDefinition(RootBeanDefinition rbd) {
        BeanDefinition dbd;
        ConfigurableListableBeanFactory clbf;
        BeanDefinitionHolder decDef = rbd.getDecoratedDefinition();
        if (decDef != null && this.beanFactory instanceof ConfigurableListableBeanFactory && (clbf = (ConfigurableListableBeanFactory)this.beanFactory).containsBeanDefinition(decDef.getBeanName()) && (dbd = clbf.getMergedBeanDefinition(decDef.getBeanName())) instanceof RootBeanDefinition) {
            return (RootBeanDefinition)dbd;
        }
        return null;
    }

    protected Annotation getFactoryMethodAnnotation(RootBeanDefinition bd, Class<? extends Annotation> type) {
        Method resolvedFactoryMethod = bd.getResolvedFactoryMethod();
        return resolvedFactoryMethod != null ? AnnotationUtils.getAnnotation((Method)resolvedFactoryMethod, type) : null;
    }

    @Override
    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        MethodParameter methodParam;
        Object value = this.findValue(descriptor.getAnnotations());
        if (value == null && (methodParam = descriptor.getMethodParameter()) != null) {
            value = this.findValue(methodParam.getMethodAnnotations());
        }
        return value;
    }

    protected Object findValue(Annotation[] annotationsToSearch) {
        for (Annotation annotation : annotationsToSearch) {
            if (!this.valueAnnotationType.isInstance(annotation)) continue;
            return this.extractValue(annotation);
        }
        for (Annotation annotation : annotationsToSearch) {
            Annotation metaAnn = annotation.annotationType().getAnnotation(this.valueAnnotationType);
            if (metaAnn == null) continue;
            return this.extractValue(metaAnn);
        }
        return null;
    }

    protected Object extractValue(Annotation valueAnnotation) {
        Object value = AnnotationUtils.getValue((Annotation)valueAnnotation);
        if (value == null) {
            throw new IllegalStateException("Value annotation must have a value attribute");
        }
        return value;
    }
}

