/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.DisposableBeanAdapter;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanFactory
extends DefaultSingletonBeanRegistry
implements ConfigurableBeanFactory {
    private BeanFactory parentBeanFactory;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean cacheBeanMetadata = true;
    private final Map customEditors = new HashMap();
    private final Set propertyEditorRegistrars = CollectionFactory.createLinkedSetIfPossible((int)16);
    private final List beanPostProcessors = new ArrayList();
    private boolean hasInstantiationAwareBeanPostProcessors;
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map scopes = new HashMap();
    private final Map aliasMap = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final Map mergedBeanDefinitions = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final Set alreadyCreated = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal prototypesCurrentlyInCreation = new ThreadLocal();
    private final Map factoryBeanObjectCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null, null);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBean(name, requiredType, null);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBean(name, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name, Class requiredType, final Object[] args) throws BeansException {
        final String beanName = this.transformedBeanName(name);
        Object bean = null;
        Object sharedInstance = this.getSingleton(beanName);
        if (sharedInstance != null) {
            if (this.logger.isDebugEnabled()) {
                if (this.isSingletonCurrentlyInCreation(beanName)) {
                    this.logger.debug((Object)("Returning eagerly cached instance of singleton bean '" + beanName + "' that is not fully initialized yet - a consequence of a circular reference"));
                } else {
                    this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
                }
            }
            if (this.containsBeanDefinition(beanName)) {
                RootBeanDefinition mbd = this.getMergedBeanDefinition(beanName, false);
                bean = this.getObjectForBeanInstance(sharedInstance, name, mbd);
            } else {
                bean = this.getObjectForBeanInstance(sharedInstance, name, null);
            }
        } else {
            if (this.isPrototypeCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            BeanFactory parentBeanFactory = this.getParentBeanFactory();
            if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
                String nameToLookup = this.originalBeanName(name);
                if (parentBeanFactory instanceof AbstractBeanFactory) {
                    return ((AbstractBeanFactory)parentBeanFactory).getBean(nameToLookup, requiredType, args);
                }
                if (args == null) {
                    return parentBeanFactory.getBean(nameToLookup, requiredType);
                }
                throw new NoSuchBeanDefinitionException(beanName, "Cannot delegate to parent BeanFactory because it does not supported passed-in arguments");
            }
            this.alreadyCreated.add(beanName);
            final RootBeanDefinition mbd = this.getMergedBeanDefinition(beanName, false);
            this.checkMergedBeanDefinition(mbd, beanName, args);
            if (mbd.isSingleton()) {
                sharedInstance = this.getSingleton(beanName, new ObjectFactory(){

                    public Object getObject() throws BeansException {
                        try {
                            return AbstractBeanFactory.this.createBean(beanName, mbd, args);
                        }
                        catch (BeansException ex) {
                            AbstractBeanFactory.this.destroySingleton(beanName);
                            throw ex;
                        }
                    }
                });
                bean = this.getObjectForBeanInstance(sharedInstance, name, mbd);
            } else if (mbd.isPrototype()) {
                Object prototypeInstance = null;
                try {
                    this.beforePrototypeCreation(beanName);
                    prototypeInstance = this.createBean(beanName, mbd, args);
                }
                finally {
                    this.afterPrototypeCreation(beanName);
                }
                bean = this.getObjectForBeanInstance(prototypeInstance, name, mbd);
            } else {
                String scopeName = mbd.getScope();
                final Scope scope = (Scope)this.scopes.get(scopeName);
                if (scope == null) {
                    throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
                }
                try {
                    Object scopedInstance = scope.get(beanName, new ObjectFactory(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object getObject() throws BeansException {
                            AbstractBeanFactory.this.beforePrototypeCreation(beanName);
                            try {
                                Object bean = AbstractBeanFactory.this.createBean(beanName, mbd, args);
                                if (AbstractBeanFactory.this.requiresDestruction(bean, mbd)) {
                                    scope.registerDestructionCallback(beanName, new DisposableBeanAdapter(bean, beanName, mbd, AbstractBeanFactory.this.getBeanPostProcessors()));
                                }
                                Object object = bean;
                                return object;
                            }
                            finally {
                                AbstractBeanFactory.this.afterPrototypeCreation(beanName);
                            }
                        }
                    });
                    bean = this.getObjectForBeanInstance(scopedInstance, name, mbd);
                }
                catch (IllegalStateException ex) {
                    throw new BeanCreationException(beanName, "Scope '" + scopeName + "' is not active for the current thread; " + "consider defining a scoped proxy for this bean if you intend to refer to it from a singleton", ex);
                }
            }
        }
        if (requiredType != null && bean != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        String beanName = this.transformedBeanName(name);
        if (this.containsSingleton(beanName) || this.containsBeanDefinition(beanName)) {
            return !BeanFactoryUtils.isFactoryDereference(name) || this.isFactoryBean(name);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        return parentBeanFactory != null && parentBeanFactory.containsBean(this.originalBeanName(name));
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean) {
                return BeanFactoryUtils.isFactoryDereference(name) || ((FactoryBean)beanInstance).isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(name);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isSingleton(this.originalBeanName(name));
        }
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
        if (bd.isSingleton()) {
            if (this.isBeanClassMatch(beanName, bd, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean)) {
                if (BeanFactoryUtils.isFactoryDereference(name)) {
                    return true;
                }
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(name);
        }
        return false;
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isPrototype(this.originalBeanName(name));
        }
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
        if (bd.isPrototype()) {
            return !BeanFactoryUtils.isFactoryDereference(name) || this.isBeanClassMatch(beanName, bd, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
        }
        if (!BeanFactoryUtils.isFactoryDereference(name) && this.isBeanClassMatch(beanName, bd, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean)) {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
            return factoryBean instanceof SmartFactoryBean && ((SmartFactoryBean)factoryBean).isPrototype() || !factoryBean.isSingleton();
        }
        return false;
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Class typeToMatch = targetType != null ? targetType : (class$java$lang$Object == null ? (class$java$lang$Object = AbstractBeanFactory.class$("java.lang.Object")) : class$java$lang$Object);
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean) {
                if (!BeanFactoryUtils.isFactoryDereference(name)) {
                    Class type = this.getTypeForFactoryBean((FactoryBean)beanInstance);
                    return type != null && typeToMatch.isAssignableFrom(type);
                }
                return typeToMatch.isAssignableFrom(beanInstance.getClass());
            }
            return !BeanFactoryUtils.isFactoryDereference(name) && typeToMatch.isAssignableFrom(beanInstance.getClass());
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isTypeMatch(this.originalBeanName(name), targetType);
        }
        RootBeanDefinition mbd = this.getMergedBeanDefinition(beanName, false);
        Class beanClass = this.predictBeanType(beanName, mbd);
        if (beanClass == null) {
            return false;
        }
        if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass)) {
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                Class type = this.getTypeForFactoryBean(beanName, mbd);
                return type != null && typeToMatch.isAssignableFrom(type);
            }
            return typeToMatch.isAssignableFrom(beanClass);
        }
        return !BeanFactoryUtils.isFactoryDereference(name) && typeToMatch.isAssignableFrom(beanClass);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
                return this.getTypeForFactoryBean((FactoryBean)beanInstance);
            }
            return beanInstance.getClass();
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.getType(this.originalBeanName(name));
        }
        RootBeanDefinition mbd = this.getMergedBeanDefinition(beanName, false);
        Class beanClass = this.predictBeanType(beanName, mbd);
        if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass)) {
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                return this.getTypeForFactoryBean(beanName, mbd);
            }
            return beanClass;
        }
        return !BeanFactoryUtils.isFactoryDereference(name) ? beanClass : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) {
        BeanFactory parentBeanFactory;
        String beanName = this.transformedBeanName(name);
        ArrayList<String> aliases = new ArrayList<String>();
        boolean factoryPrefix = name.startsWith("&");
        String fullBeanName = beanName;
        if (factoryPrefix) {
            fullBeanName = "&" + beanName;
        }
        if (!fullBeanName.equals(name)) {
            aliases.add(fullBeanName);
        }
        Map map = this.aliasMap;
        synchronized (map) {
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                String key;
                Map.Entry entry = it.next();
                if (!entry.getValue().equals(beanName) || (key = (factoryPrefix ? "&" : "") + entry.getKey()).equals(name)) continue;
                aliases.add(key);
            }
        }
        if (!this.containsSingleton(beanName) && !this.containsBeanDefinition(beanName) && (parentBeanFactory = this.getParentBeanFactory()) != null) {
            aliases.addAll(Arrays.asList(parentBeanFactory.getAliases(fullBeanName)));
        }
        return StringUtils.toStringArray(aliases);
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public boolean containsLocalBean(String name) {
        String beanName = this.transformedBeanName(name);
        return !(!this.containsSingleton(beanName) && !this.containsBeanDefinition(beanName) || BeanFactoryUtils.isFactoryDereference(name) && !this.isFactoryBean(beanName));
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        if (this.parentBeanFactory != null && this.parentBeanFactory != parentBeanFactory) {
            throw new IllegalStateException("Already associated with parent BeanFactory: " + this.parentBeanFactory);
        }
        this.parentBeanFactory = parentBeanFactory;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader != null ? beanClassLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setCacheBeanMetadata(boolean cacheBeanMetadata) {
        this.cacheBeanMetadata = cacheBeanMetadata;
    }

    public boolean isCacheBeanMetadata() {
        return this.cacheBeanMetadata;
    }

    public void addPropertyEditorRegistrar(PropertyEditorRegistrar registrar) {
        Assert.notNull((Object)registrar, (String)"PropertyEditorRegistrar must not be null");
        this.propertyEditorRegistrars.add(registrar);
    }

    public Set getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        Assert.notNull((Object)requiredType, (String)"Required type must not be null");
        Assert.notNull((Object)propertyEditor, (String)"PropertyEditor must not be null");
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public TypeConverter getTypeConverter() {
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        this.registerCustomEditors(typeConverter);
        return typeConverter;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull((Object)beanPostProcessor, (String)"BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) {
            this.hasInstantiationAwareBeanPostProcessors = true;
        }
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public int getBeanPostProcessorCount() {
        return this.beanPostProcessors.size();
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasInstantiationAwareBeanPostProcessors() {
        return this.hasInstantiationAwareBeanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    public void registerScope(String scopeName, Scope scope) {
        Assert.notNull((Object)scopeName, (String)"Scope identifier must not be null");
        Assert.notNull((Object)scope, (String)"Scope must not be null");
        if ("singleton".equals(scopeName) || "prototype".equals(scopeName)) {
            throw new IllegalArgumentException("Cannot replace existing scopes 'singleton' and 'prototype'");
        }
        this.scopes.put(scopeName, scope);
    }

    public String[] getRegisteredScopeNames() {
        return StringUtils.toStringArray(this.scopes.keySet());
    }

    public Scope getRegisteredScope(String scopeName) {
        Assert.notNull((Object)scopeName, (String)"Scope identifier must not be null");
        return (Scope)this.scopes.get(scopeName);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        Assert.notNull((Object)otherFactory, (String)"BeanFactory must not be null");
        this.setBeanClassLoader(otherFactory.getBeanClassLoader());
        this.setCacheBeanMetadata(otherFactory.isCacheBeanMetadata());
        if (otherFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory otherAbstractFactory = (AbstractBeanFactory)otherFactory;
            this.customEditors.putAll(otherAbstractFactory.customEditors);
            this.propertyEditorRegistrars.addAll(otherAbstractFactory.propertyEditorRegistrars);
            this.beanPostProcessors.addAll(otherAbstractFactory.beanPostProcessors);
            this.hasInstantiationAwareBeanPostProcessors = this.hasInstantiationAwareBeanPostProcessors || otherAbstractFactory.hasInstantiationAwareBeanPostProcessors;
            this.hasDestructionAwareBeanPostProcessors = this.hasDestructionAwareBeanPostProcessors || otherAbstractFactory.hasDestructionAwareBeanPostProcessors;
            this.scopes.putAll(otherAbstractFactory.scopes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Assert.hasText((String)alias, (String)"'alias' must not be empty");
        if (!alias.equals(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
            }
            Map map = this.aliasMap;
            synchronized (map) {
                Object registeredName = this.aliasMap.get(alias);
                if (registeredName != null && !registeredName.equals(beanName)) {
                    throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': It's already registered for bean name '" + registeredName + "'.");
                }
                this.aliasMap.put(alias, beanName);
            }
        }
    }

    protected void beforePrototypeCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        if (curVal == null) {
            this.prototypesCurrentlyInCreation.set(beanName);
        } else if (curVal instanceof String) {
            HashSet<Object> beanNameSet = new HashSet<Object>(2);
            beanNameSet.add(curVal);
            beanNameSet.add(beanName);
            this.prototypesCurrentlyInCreation.set(beanNameSet);
        } else {
            Set beanNameSet = (Set)curVal;
            beanNameSet.add(beanName);
        }
    }

    protected void afterPrototypeCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        if (curVal instanceof String) {
            this.prototypesCurrentlyInCreation.set(null);
        } else if (curVal instanceof Set) {
            Set beanNameSet = (Set)curVal;
            beanNameSet.remove(beanName);
            if (beanNameSet.isEmpty()) {
                this.prototypesCurrentlyInCreation.set(null);
            }
        }
    }

    protected final boolean isPrototypeCurrentlyInCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        return curVal != null && (curVal.equals(beanName) || curVal instanceof Set && ((Set)curVal).contains(beanName));
    }

    public boolean isCurrentlyInCreation(String beanName) {
        return this.isSingletonCurrentlyInCreation(beanName) || this.isPrototypeCurrentlyInCreation(beanName);
    }

    public void destroyBean(String beanName, Object beanInstance) {
        this.destroyBean(beanName, beanInstance, this.getMergedBeanDefinition(beanName));
    }

    protected void destroyBean(String beanName, Object beanInstance, RootBeanDefinition mbd) {
        new DisposableBeanAdapter(beanInstance, beanName, mbd, this.getBeanPostProcessors()).destroy();
    }

    public void destroyScopedBean(String beanName) {
        RootBeanDefinition mbd = this.getMergedBeanDefinition(beanName);
        if (mbd.isSingleton() || mbd.isPrototype()) {
            throw new IllegalArgumentException("Bean name '" + beanName + "' does not correspond to an object in a Scope");
        }
        String scopeName = mbd.getScope();
        Scope scope = (Scope)this.scopes.get(scopeName);
        if (scope == null) {
            throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
        }
        Object bean = scope.remove(beanName);
        if (bean != null) {
            this.destroyBean(beanName, bean, mbd);
        }
    }

    protected String transformedBeanName(String name) {
        String canonicalName = BeanFactoryUtils.transformedBeanName(name);
        String resolvedName = null;
        do {
            if ((resolvedName = (String)this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }

    protected String originalBeanName(String name) {
        String beanName = this.transformedBeanName(name);
        if (name.startsWith("&")) {
            beanName = "&" + beanName;
        }
        return beanName;
    }

    protected boolean isAlias(String beanName) {
        return this.aliasMap.containsKey(beanName);
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        this.registerCustomEditors(bw);
    }

    protected void registerCustomEditors(PropertyEditorRegistry registry) {
        PropertyEditorRegistrySupport registrySupport;
        PropertyEditorRegistrySupport propertyEditorRegistrySupport = registrySupport = registry instanceof PropertyEditorRegistrySupport ? (PropertyEditorRegistrySupport)registry : null;
        if (registrySupport != null) {
            registrySupport.useConfigValueEditors();
        }
        Iterator<Object> it = this.propertyEditorRegistrars.iterator();
        while (it.hasNext()) {
            PropertyEditorRegistrar registrar = (PropertyEditorRegistrar)it.next();
            registrar.registerCustomEditors(registry);
        }
        it = this.customEditors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Class clazz = (Class)entry.getKey();
            PropertyEditor editor = (PropertyEditor)entry.getValue();
            if (registrySupport != null) {
                registrySupport.registerSharedEditor(clazz, editor);
                continue;
            }
            registry.registerCustomEditor(clazz, editor);
        }
    }

    public RootBeanDefinition getMergedBeanDefinition(String beanName) throws BeansException {
        return this.getMergedBeanDefinition(beanName, false);
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, boolean includingAncestors) throws BeansException {
        if (includingAncestors && !this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName, true);
        }
        return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        return this.getMergedBeanDefinition(beanName, bd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd, BeanDefinition containingBd) throws BeanDefinitionStoreException {
        RootBeanDefinition mbd = null;
        if (containingBd == null) {
            mbd = (RootBeanDefinition)this.mergedBeanDefinitions.get(beanName);
        }
        if (mbd == null) {
            Map map = this.mergedBeanDefinitions;
            synchronized (map) {
                if (containingBd == null) {
                    mbd = (RootBeanDefinition)this.mergedBeanDefinitions.get(beanName);
                }
                if (mbd == null) {
                    if (bd instanceof RootBeanDefinition) {
                        mbd = new RootBeanDefinition((RootBeanDefinition)bd);
                    } else if (bd instanceof ChildBeanDefinition) {
                        RootBeanDefinition pbd;
                        ChildBeanDefinition cbd;
                        block17: {
                            cbd = (ChildBeanDefinition)bd;
                            pbd = null;
                            try {
                                String parentBeanName = this.transformedBeanName(cbd.getParentName());
                                if (!beanName.equals(parentBeanName)) {
                                    pbd = this.getMergedBeanDefinition(parentBeanName, true);
                                    break block17;
                                }
                                if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                                    AbstractBeanFactory parentFactory = (AbstractBeanFactory)this.getParentBeanFactory();
                                    pbd = parentFactory.getMergedBeanDefinition(parentBeanName, true);
                                    break block17;
                                }
                                throw new NoSuchBeanDefinitionException(cbd.getParentName(), "Parent name '" + cbd.getParentName() + "' is equal to bean name '" + beanName + "': cannot be resolved without an AbstractBeanFactory parent");
                            }
                            catch (NoSuchBeanDefinitionException ex) {
                                throw new BeanDefinitionStoreException(cbd.getResourceDescription(), beanName, "Could not resolve parent bean definition '" + cbd.getParentName() + "'", (Throwable)((Object)ex));
                            }
                        }
                        mbd = new RootBeanDefinition(pbd);
                        mbd.overrideFrom(cbd);
                    } else {
                        throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition: " + bd);
                    }
                    if (containingBd != null && !containingBd.isSingleton() && mbd.isSingleton()) {
                        mbd.setSingleton(false);
                    }
                    if (containingBd == null && this.isCacheBeanMetadata() && this.alreadyCreated.contains(beanName)) {
                        this.mergedBeanDefinitions.put(beanName, mbd);
                    }
                }
            }
        }
        return mbd;
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition mbd, String beanName, Object[] args) throws BeanDefinitionStoreException {
        if (mbd.isAbstract()) {
            throw new BeanIsAbstractException(beanName);
        }
        if (args != null) {
            if (mbd.isSingleton()) {
                throw new BeanDefinitionStoreException("Cannot specify arguments in the getBean() method when referring to a singleton bean definition");
            }
            if (mbd.getFactoryMethodName() == null) {
                throw new BeanDefinitionStoreException("Can only specify arguments in the getBean() method in conjunction with a factory method");
            }
        }
    }

    protected void clearMergedBeanDefinition(String beanName) {
        this.mergedBeanDefinitions.remove(beanName);
    }

    protected Class resolveBeanClass(RootBeanDefinition mbd, String beanName) throws CannotLoadBeanClassException {
        if (mbd.hasBeanClass()) {
            return mbd.getBeanClass();
        }
        try {
            return mbd.resolveBeanClass(this.getBeanClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), ex);
        }
        catch (LinkageError err) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), err);
        }
    }

    protected boolean isBeanClassMatch(String beanName, RootBeanDefinition mbd, Class targetType) throws CannotLoadBeanClassException {
        Class beanClass = this.resolveBeanClass(mbd, beanName);
        return beanClass != null && targetType.isAssignableFrom(beanClass);
    }

    protected Class predictBeanType(String beanName, RootBeanDefinition mbd) {
        if (mbd.getFactoryMethodName() != null) {
            return null;
        }
        return this.resolveBeanClass(mbd, beanName);
    }

    protected Class getTypeForFactoryBean(String beanName, RootBeanDefinition mbd) {
        if (!mbd.isSingleton()) {
            return null;
        }
        try {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
            return this.getTypeForFactoryBean(factoryBean);
        }
        catch (BeanCreationException ex) {
            if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? (class$org$springframework$beans$factory$BeanCurrentlyInCreationException = AbstractBeanFactory.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException")) : class$org$springframework$beans$factory$BeanCurrentlyInCreationException)) {
                this.logger.debug((Object)"Ignoring bean creation exception on FactoryBean type check", (Throwable)((Object)ex));
            } else {
                String msg = "Encountered FactoryBean creation exception for bean '" + beanName + "' - couldn't check type!";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)msg, (Throwable)((Object)ex));
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)(msg + " " + ex.toString()));
                }
            }
            return null;
        }
    }

    protected Class getTypeForFactoryBean(FactoryBean factoryBean) {
        try {
            return factoryBean.getObjectType();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectForBeanInstance(Object beanInstance, String name, RootBeanDefinition mbd) {
        if (BeanFactoryUtils.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(this.transformedBeanName(name), beanInstance.getClass());
        }
        boolean shared = mbd == null || mbd.isSingleton();
        Object object = beanInstance;
        if (beanInstance instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            FactoryBean factory = (FactoryBean)beanInstance;
            String beanName = this.transformedBeanName(name);
            if (shared && factory.isSingleton()) {
                Object object2 = this.getSingletonMutex();
                synchronized (object2) {
                    object = this.factoryBeanObjectCache.get(beanName);
                    if (object == null) {
                        object = this.getObjectFromFactoryBean(factory, beanName, mbd);
                        this.factoryBeanObjectCache.put(beanName, object);
                    }
                }
            } else {
                object = this.getObjectFromFactoryBean(factory, beanName, mbd);
            }
        }
        return object;
    }

    protected Object getObjectFromFactoryBean(FactoryBean factory, String beanName, RootBeanDefinition mbd) throws BeanCreationException {
        Object object;
        try {
            object = factory.getObject();
        }
        catch (FactoryBeanNotInitializedException ex) {
            throw new BeanCurrentlyInCreationException(beanName, ex.toString());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
        }
        if (object == null && this.isSingletonCurrentlyInCreation(beanName)) {
            throw new BeanCurrentlyInCreationException(beanName, "FactoryBean which is currently in creation returned null from getObject");
        }
        if (!(object == null || mbd != null && mbd.isSynthetic())) {
            try {
                object = this.postProcessObjectFromFactoryBean(object, beanName);
            }
            catch (Throwable ex) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Post-processing of the FactoryBean's object failed", ex);
            }
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) throws BeansException {
        return object;
    }

    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            return beanInstance instanceof FactoryBean;
        }
        if (!this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).isFactoryBean(name);
        }
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
        return this.isBeanClassMatch(beanName, bd, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
    }

    protected boolean isBeanNameInUse(String beanName) {
        return this.containsLocalBean(beanName) || this.hasDependentBean(beanName);
    }

    protected boolean requiresDestruction(Object bean, RootBeanDefinition mbd) {
        return bean instanceof DisposableBean || mbd.getDestroyMethodName() != null || this.hasDestructionAwareBeanPostProcessors();
    }

    protected void registerDisposableBeanIfNecessary(String beanName, Object bean, RootBeanDefinition mbd) {
        if (mbd.isSingleton() && this.requiresDestruction(bean, mbd)) {
            this.registerDisposableBean(beanName, new DisposableBeanAdapter(bean, beanName, mbd, this.getBeanPostProcessors()));
            String[] dependsOn = mbd.getDependsOn();
            if (dependsOn != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    this.registerDependentBean(dependsOn[i], beanName);
                }
            }
        }
    }

    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanObjectCache.remove(beanName);
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeanCreationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

