/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.ExpiringSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEntryListener
implements EntryAddedListener<String, ExpiringSession>,
EntryEvictedListener<String, ExpiringSession>,
EntryRemovedListener<String, ExpiringSession> {
    private static final Log logger = LogFactory.getLog(SessionEntryListener.class);
    private ApplicationEventPublisher eventPublisher;

    public SessionEntryListener(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    public void entryAdded(EntryEvent<String, ExpiringSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session created with id: " + ((ExpiringSession)event.getValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)event.getValue()));
    }

    public void entryEvicted(EntryEvent<String, ExpiringSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session expired with id: " + ((ExpiringSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)event.getOldValue()));
    }

    public void entryRemoved(EntryEvent<String, ExpiringSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session deleted with id: " + ((ExpiringSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)event.getOldValue()));
    }
}

