/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.lang.Nullable;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public final class ObservationWebFilterChainDecorator
implements WebFilterChainProxy.WebFilterChainDecorator {
    private static final String ATTRIBUTE = ObservationWebFilterChainDecorator.class + ".observation";
    static final String UNSECURED_OBSERVATION_NAME = "spring.security.http.unsecured.requests";
    static final String SECURED_OBSERVATION_NAME = "spring.security.http.secured.requests";
    private final ObservationRegistry registry;

    public ObservationWebFilterChainDecorator(ObservationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public WebFilterChain decorate(WebFilterChain original) {
        return this.wrapUnsecured(original);
    }

    @Override
    public WebFilterChain decorate(WebFilterChain original, List<WebFilter> filters) {
        return new ObservationWebFilterChain(arg_0 -> ((WebFilterChain)this.wrapSecured(original)).filter(arg_0), this.wrap(filters));
    }

    private static AroundWebFilterObservation observation(ServerWebExchange exchange) {
        return (AroundWebFilterObservation)exchange.getAttribute(ATTRIBUTE);
    }

    private WebFilterChain wrapSecured(WebFilterChain original) {
        return exchange -> Mono.deferContextual(contextView -> {
            AroundWebFilterObservation parent = ObservationWebFilterChainDecorator.observation(exchange);
            Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
            Observation observation = Observation.createNotStarted((String)SECURED_OBSERVATION_NAME, (ObservationRegistry)this.registry).contextualName("secured request").parentObservation(parentObservation);
            return parent.wrap(WebFilterObservation.create(observation).wrap(original)).filter(exchange);
        });
    }

    private WebFilterChain wrapUnsecured(WebFilterChain original) {
        return exchange -> Mono.deferContextual(contextView -> {
            Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
            Observation observation = Observation.createNotStarted((String)UNSECURED_OBSERVATION_NAME, (ObservationRegistry)this.registry).contextualName("unsecured request").parentObservation(parentObservation);
            return WebFilterObservation.create(observation).wrap(original).filter(exchange);
        });
    }

    private List<ObservationWebFilter> wrap(List<WebFilter> filters) {
        int size = filters.size();
        ArrayList<ObservationWebFilter> observableFilters = new ArrayList<ObservationWebFilter>();
        int position = 1;
        for (WebFilter filter : filters) {
            observableFilters.add(new ObservationWebFilter(this.registry, filter, position, size));
            ++position;
        }
        return observableFilters;
    }

    static class ObservationWebFilterChain
    implements WebFilterChain {
        private final WebHandler handler;
        @Nullable
        private final ObservationWebFilter currentFilter;
        @Nullable
        private final ObservationWebFilterChain chain;

        ObservationWebFilterChain(WebHandler handler, List<ObservationWebFilter> filters) {
            Assert.notNull((Object)handler, (String)"WebHandler is required");
            this.handler = handler;
            ObservationWebFilterChain chain = ObservationWebFilterChain.initChain(filters, handler);
            this.currentFilter = chain.currentFilter;
            this.chain = chain.chain;
        }

        private static ObservationWebFilterChain initChain(List<ObservationWebFilter> filters, WebHandler handler) {
            ObservationWebFilterChain chain = new ObservationWebFilterChain(handler, null, null);
            ListIterator<ObservationWebFilter> iterator = filters.listIterator(filters.size());
            while (iterator.hasPrevious()) {
                chain = new ObservationWebFilterChain(handler, iterator.previous(), chain);
            }
            return chain;
        }

        private ObservationWebFilterChain(WebHandler handler, @Nullable ObservationWebFilter currentFilter, @Nullable ObservationWebFilterChain chain) {
            this.currentFilter = currentFilter;
            this.handler = handler;
            this.chain = chain;
        }

        public Mono<Void> filter(ServerWebExchange exchange) {
            return Mono.defer(() -> this.currentFilter != null && this.chain != null ? this.invokeFilter(this.currentFilter, this.chain, exchange) : this.handler.handle(exchange));
        }

        private Mono<Void> invokeFilter(ObservationWebFilter current, ObservationWebFilterChain chain, ServerWebExchange exchange) {
            String currentName = current.getName();
            return current.filter(exchange, chain).checkpoint(currentName + " [DefaultWebFilterChain]");
        }
    }

    static interface AroundWebFilterObservation
    extends WebFilterObservation {
        public static final AroundWebFilterObservation NOOP = new AroundWebFilterObservation(){};

        public static AroundWebFilterObservation create(Observation before, Observation after) {
            if (before.isNoop() || after.isNoop()) {
                return NOOP;
            }
            return new SimpleAroundWebFilterObservation(before, after);
        }

        default public Observation before() {
            return Observation.NOOP;
        }

        default public Observation after() {
            return Observation.NOOP;
        }

        public static class SimpleAroundWebFilterObservation
        implements AroundWebFilterObservation {
            private final ObservationReference before;
            private final ObservationReference after;
            private final AtomicReference<ObservationReference> currentObservation = new AtomicReference<ObservationReference>(ObservationReference.NOOP);

            SimpleAroundWebFilterObservation(Observation before, Observation after) {
                this.before = new ObservationReference(before);
                this.after = new ObservationReference(after);
            }

            @Override
            public Observation start() {
                if (this.currentObservation.compareAndSet(ObservationReference.NOOP, this.before)) {
                    this.before.start();
                    return this.before.observation;
                }
                if (this.currentObservation.compareAndSet(this.before, this.after)) {
                    this.before.stop();
                    this.after.start();
                    return this.after.observation;
                }
                return Observation.NOOP;
            }

            @Override
            public Observation error(Throwable ex) {
                this.currentObservation.get().error(ex);
                return this.currentObservation.get().observation;
            }

            @Override
            public void stop() {
                this.currentObservation.get().stop();
            }

            @Override
            public Observation contextualName(String contextualName) {
                return this.currentObservation.get().observation.contextualName(contextualName);
            }

            @Override
            public Observation parentObservation(Observation parentObservation) {
                return this.currentObservation.get().observation.parentObservation(parentObservation);
            }

            @Override
            public Observation lowCardinalityKeyValue(KeyValue keyValue) {
                return this.currentObservation.get().observation.lowCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation highCardinalityKeyValue(KeyValue keyValue) {
                return this.currentObservation.get().observation.highCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation observationConvention(ObservationConvention<?> observationConvention) {
                return this.currentObservation.get().observation.observationConvention(observationConvention);
            }

            @Override
            public Observation event(Observation.Event event) {
                return this.currentObservation.get().observation.event(event);
            }

            @Override
            public Observation.Context getContext() {
                return this.currentObservation.get().observation.getContext();
            }

            @Override
            public Observation.Scope openScope() {
                return this.currentObservation.get().observation.openScope();
            }

            @Override
            public WebFilterChain wrap(WebFilterChain chain) {
                return exchange -> {
                    this.stop();
                    return chain.filter(exchange).doOnSuccess(v -> this.start()).doOnCancel(this::start).doOnError(t -> {
                        this.error((Throwable)t);
                        this.start();
                    });
                };
            }

            @Override
            public WebFilter wrap(WebFilter filter) {
                return (exchange, chain) -> {
                    this.start();
                    return filter.filter(exchange, chain).doOnSuccess(v -> this.stop()).doOnCancel(this::stop).doOnError(t -> {
                        this.error((Throwable)t);
                        this.stop();
                    }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)this));
                };
            }

            @Override
            public Observation before() {
                return this.before.observation;
            }

            @Override
            public Observation after() {
                return this.after.observation;
            }

            public String toString() {
                return this.currentObservation.get().observation.toString();
            }

            private static final class ObservationReference {
                private static final ObservationReference NOOP = new ObservationReference(Observation.NOOP);
                private final Lock lock = new ReentrantLock();
                private final AtomicInteger state = new AtomicInteger(0);
                private final Observation observation;

                private ObservationReference(Observation observation) {
                    this.observation = observation;
                }

                private void start() {
                    try {
                        this.lock.lock();
                        if (this.state.compareAndSet(0, 1)) {
                            this.observation.start();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }

                private void error(Throwable ex) {
                    try {
                        this.lock.lock();
                        if (this.state.get() == 1) {
                            this.observation.error(ex);
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }

                private void stop() {
                    try {
                        this.lock.lock();
                        if (this.state.compareAndSet(1, 2)) {
                            this.observation.stop();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    static final class ObservationWebFilter
    implements WebFilter {
        private final ObservationRegistry registry;
        private final WebFilterChainObservationConvention convention = new WebFilterChainObservationConvention();
        private final WebFilter filter;
        private final String name;
        private final int position;
        private final int size;

        ObservationWebFilter(ObservationRegistry registry, WebFilter filter, int position, int size) {
            this.registry = registry;
            this.filter = filter;
            this.name = filter.getClass().getSimpleName();
            this.position = position;
            this.size = size;
        }

        String getName() {
            return this.name;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            if (this.position == 1) {
                return Mono.deferContextual(contextView -> {
                    Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
                    AroundWebFilterObservation parent = this.parent(exchange, parentObservation);
                    return parent.wrap(this::wrapFilter).filter(exchange, chain);
                });
            }
            return this.wrapFilter(exchange, chain);
        }

        private Mono<Void> wrapFilter(ServerWebExchange exchange, WebFilterChain chain) {
            AroundWebFilterObservation parent = ObservationWebFilterChainDecorator.observation(exchange);
            Observation.Context context = parent.before().getContext();
            if (context instanceof WebFilterChainObservationContext) {
                WebFilterChainObservationContext parentBefore = (WebFilterChainObservationContext)context;
                parentBefore.setChainSize(this.size);
                parentBefore.setFilterName(this.name);
                parentBefore.setChainPosition(this.position);
            }
            return this.filter.filter(exchange, chain).doOnSuccess(result -> {
                parent.start();
                Observation.Context patt7947$temp = parent.after().getContext();
                if (patt7947$temp instanceof WebFilterChainObservationContext) {
                    WebFilterChainObservationContext parentAfter = (WebFilterChainObservationContext)patt7947$temp;
                    parentAfter.setChainSize(this.size);
                    parentAfter.setFilterName(this.name);
                    parentAfter.setChainPosition(this.size - this.position + 1);
                }
            });
        }

        private AroundWebFilterObservation parent(ServerWebExchange exchange, Observation parentObservation) {
            WebFilterChainObservationContext beforeContext = WebFilterChainObservationContext.before();
            WebFilterChainObservationContext afterContext = WebFilterChainObservationContext.after();
            Observation before = Observation.createNotStarted((ObservationConvention)this.convention, () -> beforeContext, (ObservationRegistry)this.registry).parentObservation(parentObservation);
            Observation after = Observation.createNotStarted((ObservationConvention)this.convention, () -> afterContext, (ObservationRegistry)this.registry).parentObservation(parentObservation);
            AroundWebFilterObservation parent = AroundWebFilterObservation.create(before, after);
            exchange.getAttributes().put(ATTRIBUTE, parent);
            return parent;
        }
    }

    static interface WebFilterObservation
    extends Observation {
        public static final WebFilterObservation NOOP = new WebFilterObservation(){};

        public static WebFilterObservation create(Observation observation) {
            if (observation.isNoop()) {
                return NOOP;
            }
            return new SimpleWebFilterObservation(observation);
        }

        default public Observation contextualName(String contextualName) {
            return Observation.NOOP;
        }

        default public Observation parentObservation(Observation parentObservation) {
            return Observation.NOOP;
        }

        default public Observation lowCardinalityKeyValue(KeyValue keyValue) {
            return Observation.NOOP;
        }

        default public Observation highCardinalityKeyValue(KeyValue keyValue) {
            return Observation.NOOP;
        }

        default public Observation observationConvention(ObservationConvention<?> observationConvention) {
            return Observation.NOOP;
        }

        default public Observation error(Throwable error) {
            return Observation.NOOP;
        }

        default public Observation event(Observation.Event event) {
            return Observation.NOOP;
        }

        default public Observation start() {
            return Observation.NOOP;
        }

        default public Observation.Context getContext() {
            return new Observation.Context();
        }

        default public void stop() {
        }

        default public Observation.Scope openScope() {
            return Observation.Scope.NOOP;
        }

        default public WebFilter wrap(WebFilter filter) {
            return filter;
        }

        default public WebFilterChain wrap(WebFilterChain chain) {
            return chain;
        }

        public static class SimpleWebFilterObservation
        implements WebFilterObservation {
            private final Observation observation;

            SimpleWebFilterObservation(Observation observation) {
                this.observation = observation;
            }

            @Override
            public Observation start() {
                return this.observation.start();
            }

            @Override
            public Observation error(Throwable ex) {
                return this.observation.error(ex);
            }

            @Override
            public void stop() {
                this.observation.stop();
            }

            @Override
            public Observation contextualName(String contextualName) {
                return this.observation.contextualName(contextualName);
            }

            @Override
            public Observation parentObservation(Observation parentObservation) {
                return this.observation.parentObservation(parentObservation);
            }

            @Override
            public Observation lowCardinalityKeyValue(KeyValue keyValue) {
                return this.observation.lowCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation highCardinalityKeyValue(KeyValue keyValue) {
                return this.observation.highCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation observationConvention(ObservationConvention<?> observationConvention) {
                return this.observation.observationConvention(observationConvention);
            }

            @Override
            public Observation event(Observation.Event event) {
                return this.observation.event(event);
            }

            @Override
            public Observation.Context getContext() {
                return this.observation.getContext();
            }

            @Override
            public Observation.Scope openScope() {
                return this.observation.openScope();
            }

            @Override
            public WebFilter wrap(WebFilter filter) {
                if (this.observation.isNoop()) {
                    return filter;
                }
                return (exchange, chain) -> {
                    this.observation.start();
                    return filter.filter(exchange, chain).doOnSuccess(v -> this.observation.stop()).doOnCancel(() -> ((Observation)this.observation).stop()).doOnError(t -> {
                        this.observation.error(t);
                        this.observation.stop();
                    });
                };
            }

            @Override
            public WebFilterChain wrap(WebFilterChain chain) {
                if (this.observation.isNoop()) {
                    return chain;
                }
                return exchange -> {
                    this.observation.start();
                    return chain.filter(exchange).doOnSuccess(v -> this.observation.stop()).doOnCancel(() -> ((Observation)this.observation).stop()).doOnError(t -> {
                        this.observation.error(t);
                        this.observation.stop();
                    }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)this.observation));
                };
            }
        }
    }

    static final class WebFilterChainObservationConvention
    implements ObservationConvention<WebFilterChainObservationContext> {
        static final String CHAIN_OBSERVATION_NAME = "spring.security.filterchains";
        private static final String CHAIN_POSITION_NAME = "spring.security.filterchain.position";
        private static final String CHAIN_SIZE_NAME = "spring.security.filterchain.size";
        private static final String FILTER_SECTION_NAME = "spring.security.reached.filter.section";
        private static final String FILTER_NAME = "spring.security.reached.filter.name";

        WebFilterChainObservationConvention() {
        }

        public String getName() {
            return CHAIN_OBSERVATION_NAME;
        }

        public String getContextualName(WebFilterChainObservationContext context) {
            return "security filterchain " + context.getFilterSection();
        }

        public KeyValues getLowCardinalityKeyValues(WebFilterChainObservationContext context) {
            return KeyValues.of((String)CHAIN_SIZE_NAME, (String)String.valueOf(context.getChainSize())).and(CHAIN_POSITION_NAME, String.valueOf(context.getChainPosition())).and(FILTER_SECTION_NAME, context.getFilterSection()).and(FILTER_NAME, StringUtils.hasText((String)context.getFilterName()) ? context.getFilterName() : "none");
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof WebFilterChainObservationContext;
        }
    }

    static final class WebFilterChainObservationContext
    extends Observation.Context {
        private final String filterSection;
        private String filterName;
        private int chainPosition;
        private int chainSize;

        private WebFilterChainObservationContext(String filterSection) {
            this.filterSection = filterSection;
        }

        static WebFilterChainObservationContext before() {
            return new WebFilterChainObservationContext("before");
        }

        static WebFilterChainObservationContext after() {
            return new WebFilterChainObservationContext("after");
        }

        String getFilterSection() {
            return this.filterSection;
        }

        String getFilterName() {
            return this.filterName;
        }

        void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        int getChainPosition() {
            return this.chainPosition;
        }

        void setChainPosition(int chainPosition) {
            this.chainPosition = chainPosition;
        }

        int getChainSize() {
            return this.chainSize;
        }

        void setChainSize(int chainSize) {
            this.chainSize = chainSize;
        }
    }
}

