/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context.support;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SecurityWebApplicationContextUtils
extends WebApplicationContextUtils {
    public static WebApplicationContext findRequiredWebApplicationContext(ServletContext servletContext) {
        WebApplicationContext webApplicationContext = SecurityWebApplicationContextUtils.compatiblyFindWebApplicationContext(servletContext);
        Assert.state((webApplicationContext != null ? 1 : 0) != 0, (String)"No WebApplicationContext found: no ContextLoaderListener registered?");
        return webApplicationContext;
    }

    private static WebApplicationContext compatiblyFindWebApplicationContext(ServletContext sc) {
        WebApplicationContext webApplicationContext = SecurityWebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        if (webApplicationContext == null) {
            Enumeration attrNames = sc.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attrValue = sc.getAttribute(attrName);
                if (!(attrValue instanceof WebApplicationContext)) continue;
                Assert.state((webApplicationContext == null ? 1 : 0) != 0, (String)"No unique WebApplicationContext found: more than one DispatcherServlet registered with publishContext=true?");
                webApplicationContext = (WebApplicationContext)attrValue;
            }
        }
        return webApplicationContext;
    }
}

