/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationServerMetadata;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.http.converter.OAuth2AuthorizationServerMetadataHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationServerMetadataEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OAUTH2_AUTHORIZATION_SERVER_METADATA_ENDPOINT_URI = "/.well-known/oauth-authorization-server";
    private final RequestMatcher requestMatcher = OAuth2AuthorizationServerMetadataEndpointFilter.createRequestMatcher();
    private final OAuth2AuthorizationServerMetadataHttpMessageConverter authorizationServerMetadataHttpMessageConverter = new OAuth2AuthorizationServerMetadataHttpMessageConverter();
    private Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer = authorizationServerMetadata -> {};

    public void setAuthorizationServerMetadataCustomizer(Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer) {
        Assert.notNull(authorizationServerMetadataCustomizer, (String)"authorizationServerMetadataCustomizer cannot be null");
        this.authorizationServerMetadataCustomizer = authorizationServerMetadataCustomizer;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
        String issuer = authorizationServerContext.getIssuer();
        AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
        OAuth2AuthorizationServerMetadata.Builder authorizationServerMetadata = (OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)OAuth2AuthorizationServerMetadata.builder().issuer(issuer)).authorizationEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getAuthorizationEndpoint()))).deviceAuthorizationEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getDeviceAuthorizationEndpoint()))).tokenEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenEndpoint()))).tokenEndpointAuthenticationMethods((Consumer)OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).jwkSetUrl(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getJwkSetEndpoint()))).responseType(OAuth2AuthorizationResponseType.CODE.getValue())).grantType(AuthorizationGrantType.AUTHORIZATION_CODE.getValue())).grantType(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).grantType(AuthorizationGrantType.REFRESH_TOKEN.getValue())).grantType(AuthorizationGrantType.DEVICE_CODE.getValue())).grantType(AuthorizationGrantType.TOKEN_EXCHANGE.getValue())).tokenRevocationEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenRevocationEndpoint()))).tokenRevocationEndpointAuthenticationMethods((Consumer)OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).tokenIntrospectionEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenIntrospectionEndpoint()))).tokenIntrospectionEndpointAuthenticationMethods((Consumer)OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).codeChallengeMethod("S256")).tlsClientCertificateBoundAccessTokens(true)).dPoPSigningAlgorithms((Consumer)OAuth2AuthorizationServerMetadataEndpointFilter.dPoPSigningAlgorithms());
        this.authorizationServerMetadataCustomizer.accept(authorizationServerMetadata);
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.authorizationServerMetadataHttpMessageConverter.write(authorizationServerMetadata.build(), MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }

    private static RequestMatcher createRequestMatcher() {
        AntPathRequestMatcher defaultRequestMatcher = new AntPathRequestMatcher(DEFAULT_OAUTH2_AUTHORIZATION_SERVER_METADATA_ENDPOINT_URI, HttpMethod.GET.name());
        AntPathRequestMatcher multipleIssuersRequestMatcher = new AntPathRequestMatcher("/.well-known/oauth-authorization-server/**", HttpMethod.GET.name());
        return arg_0 -> OAuth2AuthorizationServerMetadataEndpointFilter.lambda$createRequestMatcher$1((RequestMatcher)multipleIssuersRequestMatcher, (RequestMatcher)defaultRequestMatcher, arg_0);
    }

    private static Consumer<List<String>> clientAuthenticationMethods() {
        return authenticationMethods -> {
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.TLS_CLIENT_AUTH.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.getValue());
        };
    }

    private static Consumer<List<String>> dPoPSigningAlgorithms() {
        return algs -> {
            algs.add("RS256");
            algs.add("RS384");
            algs.add("RS512");
            algs.add("PS256");
            algs.add("PS384");
            algs.add("PS512");
            algs.add("ES256");
            algs.add("ES384");
            algs.add("ES512");
        };
    }

    private static String asUrl(String issuer, String endpoint) {
        return UriComponentsBuilder.fromUriString((String)issuer).path(endpoint).toUriString();
    }

    private static /* synthetic */ boolean lambda$createRequestMatcher$1(RequestMatcher multipleIssuersRequestMatcher, RequestMatcher defaultRequestMatcher, HttpServletRequest request) {
        return AuthorizationServerContextHolder.getContext().getAuthorizationServerSettings().isMultipleIssuersAllowed() ? multipleIssuersRequestMatcher.matches(request) : defaultRequestMatcher.matches(request);
    }
}

