/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.time.Instant;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2DeviceAuthorizationRequestAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    static final OAuth2TokenType DEVICE_CODE_TOKEN_TYPE = new OAuth2TokenType("device_code");
    static final OAuth2TokenType USER_CODE_TOKEN_TYPE = new OAuth2TokenType("user_code");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OAuth2AuthorizationService authorizationService;
    private OAuth2TokenGenerator<OAuth2DeviceCode> deviceCodeGenerator = new OAuth2DeviceCodeGenerator();
    private OAuth2TokenGenerator<OAuth2UserCode> userCodeGenerator = new OAuth2UserCodeGenerator();

    public OAuth2DeviceAuthorizationRequestAuthenticationProvider(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2UserCode userCode;
        DefaultOAuth2TokenContext.Builder tokenContextBuilder;
        DefaultOAuth2TokenContext tokenContext;
        OAuth2DeviceCode deviceCode;
        Set<String> requestedScopes;
        OAuth2DeviceAuthorizationRequestAuthenticationToken deviceAuthorizationRequestAuthentication = (OAuth2DeviceAuthorizationRequestAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)deviceAuthorizationRequestAuthentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.DEVICE_CODE)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)LogMessage.format((String)"Invalid request: requested grant_type is not allowed for registered client '%s'", (Object)registeredClient.getId()));
            }
            OAuth2DeviceAuthorizationRequestAuthenticationProvider.throwError("unauthorized_client", "client_id");
        }
        if (!CollectionUtils.isEmpty(requestedScopes = deviceAuthorizationRequestAuthentication.getScopes())) {
            for (String requestedScope : requestedScopes) {
                if (registeredClient.getScopes().contains(requestedScope)) continue;
                OAuth2DeviceAuthorizationRequestAuthenticationProvider.throwError("invalid_scope", "scope");
            }
            if (requestedScopes.contains("openid")) {
                OAuth2DeviceAuthorizationRequestAuthenticationProvider.throwError("invalid_scope", "scope");
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated device authorization request parameters");
        }
        if ((deviceCode = this.deviceCodeGenerator.generate(tokenContext = ((DefaultOAuth2TokenContext.Builder)(tokenContextBuilder = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)clientPrincipal)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorizationGrantType(AuthorizationGrantType.DEVICE_CODE)).authorizationGrant((Authentication)deviceAuthorizationRequestAuthentication)).tokenType(DEVICE_CODE_TOKEN_TYPE)).build())) == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the device code.", ERROR_URI);
            throw new OAuth2AuthenticationException(error);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated device code");
        }
        if ((userCode = this.userCodeGenerator.generate(tokenContext = ((DefaultOAuth2TokenContext.Builder)tokenContextBuilder.tokenType(USER_CODE_TOKEN_TYPE)).build())) == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the user code.", ERROR_URI);
            throw new OAuth2AuthenticationException(error);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated user code");
        }
        OAuth2Authorization authorization = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(clientPrincipal.getName()).authorizationGrantType(AuthorizationGrantType.DEVICE_CODE).token(deviceCode).token(userCode).attribute("scope", new HashSet<String>(requestedScopes)).build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated device authorization request");
        }
        return new OAuth2DeviceAuthorizationRequestAuthenticationToken((Authentication)clientPrincipal, requestedScopes, deviceCode, userCode);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2DeviceAuthorizationRequestAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setDeviceCodeGenerator(OAuth2TokenGenerator<OAuth2DeviceCode> deviceCodeGenerator) {
        Assert.notNull(deviceCodeGenerator, (String)"deviceCodeGenerator cannot be null");
        this.deviceCodeGenerator = deviceCodeGenerator;
    }

    public void setUserCodeGenerator(OAuth2TokenGenerator<OAuth2UserCode> userCodeGenerator) {
        Assert.notNull(userCodeGenerator, (String)"userCodeGenerator cannot be null");
        this.userCodeGenerator = userCodeGenerator;
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, ERROR_URI);
        throw new OAuth2AuthenticationException(error);
    }

    private static final class OAuth2DeviceCodeGenerator
    implements OAuth2TokenGenerator<OAuth2DeviceCode> {
        private final StringKeyGenerator deviceCodeGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);

        private OAuth2DeviceCodeGenerator() {
        }

        @Override
        @Nullable
        public OAuth2DeviceCode generate(OAuth2TokenContext context) {
            if (context.getTokenType() == null || !"device_code".equals(context.getTokenType().getValue())) {
                return null;
            }
            Instant issuedAt = Instant.now();
            Instant expiresAt = issuedAt.plus(context.getRegisteredClient().getTokenSettings().getDeviceCodeTimeToLive());
            return new OAuth2DeviceCode(this.deviceCodeGenerator.generateKey(), issuedAt, expiresAt);
        }
    }

    private static final class OAuth2UserCodeGenerator
    implements OAuth2TokenGenerator<OAuth2UserCode> {
        private final StringKeyGenerator userCodeGenerator = new UserCodeStringKeyGenerator();

        private OAuth2UserCodeGenerator() {
        }

        @Override
        @Nullable
        public OAuth2UserCode generate(OAuth2TokenContext context) {
            if (context.getTokenType() == null || !"user_code".equals(context.getTokenType().getValue())) {
                return null;
            }
            Instant issuedAt = Instant.now();
            Instant expiresAt = issuedAt.plus(context.getRegisteredClient().getTokenSettings().getDeviceCodeTimeToLive());
            return new OAuth2UserCode(this.userCodeGenerator.generateKey(), issuedAt, expiresAt);
        }
    }

    private static final class UserCodeStringKeyGenerator
    implements StringKeyGenerator {
        private static final char[] VALID_CHARS = new char[]{'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'};
        private final BytesKeyGenerator keyGenerator = KeyGenerators.secureRandom((int)8);

        private UserCodeStringKeyGenerator() {
        }

        public String generateKey() {
            byte[] bytes = this.keyGenerator.generateKey();
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                int offset = Math.abs(b % 20);
                sb.append(VALID_CHARS[offset]);
            }
            sb.insert(4, '-');
            return sb.toString();
        }
    }
}

