/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.OidcUserInfoHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OidcUserInfoEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_USER_INFO_ENDPOINT_URI = "/userinfo";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher userInfoEndpointMatcher;
    private final HttpMessageConverter<OidcUserInfo> userInfoHttpMessageConverter = new OidcUserInfoHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();
    private AuthenticationConverter authenticationConverter = this::createAuthentication;
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::sendUserInfoResponse;
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;

    public OidcUserInfoEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_OIDC_USER_INFO_ENDPOINT_URI);
    }

    public OidcUserInfoEndpointFilter(AuthenticationManager authenticationManager, String userInfoEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)userInfoEndpointUri, (String)"userInfoEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.userInfoEndpointMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.GET.name()), new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.POST.name())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.userInfoEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication userInfoAuthentication = this.authenticationConverter.convert(request);
            Authentication userInfoAuthenticationResult = this.authenticationManager.authenticate(userInfoAuthentication);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, userInfoAuthenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"User info request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Connect 1.0 UserInfo Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-core-1_0.html#UserInfoError");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)error.getDescription(), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)new OAuth2AuthenticationException(error));
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    private Authentication createAuthentication(HttpServletRequest request) {
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        return new OidcUserInfoAuthenticationToken(principal);
    }

    private void sendUserInfoResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OidcUserInfoAuthenticationToken userInfoAuthenticationToken = (OidcUserInfoAuthenticationToken)authentication;
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.userInfoHttpMessageConverter.write((Object)userInfoAuthenticationToken.getUserInfo(), null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException {
        OAuth2Error error = ((OAuth2AuthenticationException)authenticationException).getError();
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        if (error.getErrorCode().equals("invalid_token")) {
            httpStatus = HttpStatus.UNAUTHORIZED;
        } else if (error.getErrorCode().equals("insufficient_scope")) {
            httpStatus = HttpStatus.FORBIDDEN;
        }
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode((HttpStatusCode)httpStatus);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }
}

