/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceVerificationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;

public final class OAuth2DeviceAuthorizationConsentAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    static final OAuth2TokenType STATE_TOKEN_TYPE = new OAuth2TokenType("state");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2AuthorizationConsentService authorizationConsentService;
    private Consumer<OAuth2AuthorizationConsentAuthenticationContext> authorizationConsentCustomizer;

    public OAuth2DeviceAuthorizationConsentAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.authorizationConsentService = authorizationConsentService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AuthorizationConsent authorizationConsent;
        OAuth2AuthorizationConsent.Builder authorizationConsentBuilder;
        OAuth2AuthorizationConsent currentAuthorizationConsent;
        Set<Object> currentAuthorizedScopes;
        HashSet<String> authorizedScopes;
        Set requestedScopes;
        RegisteredClient registeredClient;
        Authentication principal;
        OAuth2DeviceAuthorizationConsentAuthenticationToken deviceAuthorizationConsentAuthentication = (OAuth2DeviceAuthorizationConsentAuthenticationToken)authentication;
        OAuth2Authorization authorization = this.authorizationService.findByToken(deviceAuthorizationConsentAuthentication.getState(), STATE_TOKEN_TYPE);
        if (authorization == null) {
            OAuth2DeviceAuthorizationConsentAuthenticationProvider.throwError("invalid_request", "state");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with device authorization consent state");
        }
        if (!OAuth2DeviceAuthorizationConsentAuthenticationProvider.isPrincipalAuthenticated(principal = (Authentication)deviceAuthorizationConsentAuthentication.getPrincipal()) || !principal.getName().equals(authorization.getPrincipalName())) {
            OAuth2DeviceAuthorizationConsentAuthenticationProvider.throwError("invalid_request", "state");
        }
        if ((registeredClient = this.registeredClientRepository.findByClientId(deviceAuthorizationConsentAuthentication.getClientId())) == null || !registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            OAuth2DeviceAuthorizationConsentAuthenticationProvider.throwError("invalid_request", "client_id");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!(requestedScopes = (Set)authorization.getAttribute("scope")).containsAll(authorizedScopes = new HashSet<String>(deviceAuthorizationConsentAuthentication.getScopes()))) {
            OAuth2DeviceAuthorizationConsentAuthenticationProvider.throwError("invalid_scope", "scope");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated device authorization consent request parameters");
        }
        Set<Object> set = currentAuthorizedScopes = (currentAuthorizationConsent = this.authorizationConsentService.findById(authorization.getRegisteredClientId(), principal.getName())) != null ? currentAuthorizationConsent.getScopes() : Collections.emptySet();
        if (!currentAuthorizedScopes.isEmpty()) {
            for (String requestedScope : requestedScopes) {
                if (!currentAuthorizedScopes.contains(requestedScope)) continue;
                authorizedScopes.add(requestedScope);
            }
        }
        if (currentAuthorizationConsent != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Retrieved existing authorization consent");
            }
            authorizationConsentBuilder = OAuth2AuthorizationConsent.from(currentAuthorizationConsent);
        } else {
            authorizationConsentBuilder = OAuth2AuthorizationConsent.withId(authorization.getRegisteredClientId(), principal.getName());
        }
        authorizedScopes.forEach(authorizationConsentBuilder::scope);
        if (this.authorizationConsentCustomizer != null) {
            OAuth2AuthorizationConsentAuthenticationContext authorizationConsentAuthenticationContext = OAuth2AuthorizationConsentAuthenticationContext.with(deviceAuthorizationConsentAuthentication).authorizationConsent(authorizationConsentBuilder).registeredClient(registeredClient).authorization(authorization).build();
            this.authorizationConsentCustomizer.accept(authorizationConsentAuthenticationContext);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Customized authorization consent");
            }
        }
        HashSet authorities = new HashSet();
        authorizationConsentBuilder.authorities(authorities::addAll);
        OAuth2Authorization.Token<OAuth2DeviceCode> deviceCodeToken = authorization.getToken(OAuth2DeviceCode.class);
        OAuth2Authorization.Token<OAuth2UserCode> userCodeToken = authorization.getToken(OAuth2UserCode.class);
        if (authorities.isEmpty()) {
            if (currentAuthorizationConsent != null) {
                this.authorizationConsentService.remove(currentAuthorizationConsent);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Revoked authorization consent");
                }
            }
            authorization = OAuth2Authorization.from(authorization).invalidate(deviceCodeToken.getToken()).invalidate(userCodeToken.getToken()).attributes(attrs -> attrs.remove("state")).build();
            this.authorizationService.save(authorization);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Invalidated device code and user code because authorization consent was denied");
            }
            OAuth2DeviceAuthorizationConsentAuthenticationProvider.throwError("access_denied", "client_id");
        }
        if (!(authorizationConsent = authorizationConsentBuilder.build()).equals(currentAuthorizationConsent)) {
            this.authorizationConsentService.save(authorizationConsent);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Saved authorization consent");
            }
        }
        authorization = OAuth2Authorization.from(authorization).authorizedScopes(authorizedScopes).invalidate(userCodeToken.getToken()).attributes(attrs -> attrs.remove("state")).attributes(attrs -> attrs.remove("scope")).build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization with authorized scopes");
            this.logger.trace((Object)"Authenticated device authorization consent request");
        }
        return new OAuth2DeviceVerificationAuthenticationToken(principal, deviceAuthorizationConsentAuthentication.getUserCode(), registeredClient.getClientId());
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2DeviceAuthorizationConsentAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthorizationConsentCustomizer(Consumer<OAuth2AuthorizationConsentAuthenticationContext> authorizationConsentCustomizer) {
        Assert.notNull(authorizationConsentCustomizer, (String)"authorizationConsentCustomizer cannot be null");
        this.authorizationConsentCustomizer = authorizationConsentCustomizer;
    }

    private static boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null && !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) && principal.isAuthenticated();
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, ERROR_URI);
        throw new OAuth2AuthenticationException(error);
    }
}

