/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.util.function.Consumer;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.util.StringUtils;

public final class OidcLogoutAuthenticationValidator
implements Consumer<OidcLogoutAuthenticationContext> {
    public static final Consumer<OidcLogoutAuthenticationContext> DEFAULT_POST_LOGOUT_REDIRECT_URI_VALIDATOR = OidcLogoutAuthenticationValidator::validatePostLogoutRedirectUri;
    private final Consumer<OidcLogoutAuthenticationContext> authenticationValidator = DEFAULT_POST_LOGOUT_REDIRECT_URI_VALIDATOR;

    @Override
    public void accept(OidcLogoutAuthenticationContext authenticationContext) {
        this.authenticationValidator.accept(authenticationContext);
    }

    private static void validatePostLogoutRedirectUri(OidcLogoutAuthenticationContext authenticationContext) {
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)((Object)authenticationContext.getAuthentication());
        RegisteredClient registeredClient = authenticationContext.getRegisteredClient();
        if (StringUtils.hasText((String)oidcLogoutAuthentication.getPostLogoutRedirectUri()) && !registeredClient.getPostLogoutRedirectUris().contains(oidcLogoutAuthentication.getPostLogoutRedirectUri())) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Connect 1.0 Logout Request Parameter: post_logout_redirect_uri", "https://openid.net/specs/openid-connect-rpinitiated-1_0.html#ValidationAndErrorHandling");
            throw new OAuth2AuthenticationException(error);
        }
    }
}

