/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt.crypto.sign;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignerVerifier;

public class MacSigner
implements SignerVerifier {
    private static final String DEFAULT_ALGORITHM = "HMACSHA256";
    private final String algorithm;
    private final SecretKey key;

    public MacSigner(byte[] key) {
        this(new SecretKeySpec(key, DEFAULT_ALGORITHM));
    }

    public MacSigner(String key) {
        this(new SecretKeySpec(key.getBytes(), DEFAULT_ALGORITHM));
    }

    public MacSigner(SecretKey key) {
        this(DEFAULT_ALGORITHM, key);
    }

    public MacSigner(String algorithm, SecretKey key) {
        this.key = key;
        this.algorithm = algorithm;
    }

    @Override
    public byte[] sign(byte[] bytes) {
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(this.key);
            return mac.doFinal(bytes);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void verify(byte[] content, byte[] signature) {
        byte[] signed = this.sign(content);
        if (!this.isEqual(signed, signature)) {
            throw new InvalidSignatureException("Calculated signature did not match actual value");
        }
    }

    private boolean isEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int xor = 0;
        int i = 0;
        while (i < b1.length) {
            xor |= b1[i] ^ b2[i];
            ++i;
        }
        return xor == 0;
    }

    @Override
    public String algorithm() {
        return this.algorithm;
    }

    public String toString() {
        return "MacSigner: " + this.algorithm;
    }
}

