/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public abstract class AbstractLdapAuthenticationManagerFactory<T extends AbstractLdapAuthenticator> {
    private BaseLdapPathContextSource contextSource;
    private String[] userDnPatterns;
    private LdapAuthoritiesPopulator ldapAuthoritiesPopulator;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private UserDetailsContextMapper userDetailsContextMapper;
    private String userSearchFilter;
    private String userSearchBase = "";

    AbstractLdapAuthenticationManagerFactory(BaseLdapPathContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setContextSource(BaseLdapPathContextSource contextSource) {
        this.contextSource = contextSource;
    }

    protected final BaseLdapPathContextSource getContextSource() {
        return this.contextSource;
    }

    public void setLdapAuthoritiesPopulator(LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setUserDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        this.userDetailsContextMapper = userDetailsContextMapper;
    }

    public void setUserDnPatterns(String ... userDnPatterns) {
        this.userDnPatterns = userDnPatterns;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public final AuthenticationManager createAuthenticationManager() {
        LdapAuthenticationProvider ldapAuthenticationProvider = this.getProvider();
        return new ProviderManager(new AuthenticationProvider[]{ldapAuthenticationProvider});
    }

    private LdapAuthenticationProvider getProvider() {
        AbstractLdapAuthenticator authenticator = this.getAuthenticator();
        LdapAuthenticationProvider provider = this.ldapAuthoritiesPopulator != null ? new LdapAuthenticationProvider((LdapAuthenticator)authenticator, this.ldapAuthoritiesPopulator) : new LdapAuthenticationProvider((LdapAuthenticator)authenticator);
        if (this.authoritiesMapper != null) {
            provider.setAuthoritiesMapper(this.authoritiesMapper);
        }
        if (this.userDetailsContextMapper != null) {
            provider.setUserDetailsContextMapper(this.userDetailsContextMapper);
        }
        return provider;
    }

    private AbstractLdapAuthenticator getAuthenticator() {
        T authenticator = this.createDefaultLdapAuthenticator();
        if (this.userSearchFilter != null) {
            authenticator.setUserSearch((LdapUserSearch)new FilterBasedLdapUserSearch(this.userSearchBase, this.userSearchFilter, this.contextSource));
        }
        if (this.userDnPatterns != null && this.userDnPatterns.length > 0) {
            authenticator.setUserDnPatterns(this.userDnPatterns);
        }
        authenticator.afterPropertiesSet();
        return authenticator;
    }

    protected abstract T createDefaultLdapAuthenticator();
}

