/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.util.ClassUtils;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class CorsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CorsConfigurer<H>, H> {
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final String CORS_CONFIGURATION_SOURCE_BEAN_NAME = "corsConfigurationSource";
    private static final String CORS_FILTER_BEAN_NAME = "corsFilter";
    private CorsConfigurationSource configurationSource;

    public CorsConfigurer<H> configurationSource(CorsConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        CorsFilter corsFilter = this.getCorsFilter(context);
        if (corsFilter == null) {
            throw new IllegalStateException("Please configure either a corsFilter bean or a corsConfigurationSourcebean.");
        }
        http.addFilter((Filter)corsFilter);
    }

    private CorsFilter getCorsFilter(ApplicationContext context) {
        if (this.configurationSource != null) {
            return new CorsFilter(this.configurationSource);
        }
        boolean containsCorsFilter = context.containsBeanDefinition(CORS_FILTER_BEAN_NAME);
        if (containsCorsFilter) {
            return (CorsFilter)context.getBean(CORS_FILTER_BEAN_NAME, CorsFilter.class);
        }
        boolean containsCorsSource = context.containsBean(CORS_CONFIGURATION_SOURCE_BEAN_NAME);
        if (containsCorsSource) {
            CorsConfigurationSource configurationSource = (CorsConfigurationSource)context.getBean(CORS_CONFIGURATION_SOURCE_BEAN_NAME, CorsConfigurationSource.class);
            return new CorsFilter(configurationSource);
        }
        boolean mvcPresent = ClassUtils.isPresent((String)HANDLER_MAPPING_INTROSPECTOR, (ClassLoader)context.getClassLoader());
        if (mvcPresent) {
            return MvcCorsFilter.getMvcCorsFilter(context);
        }
        return null;
    }

    static class MvcCorsFilter {
        MvcCorsFilter() {
        }

        private static CorsFilter getMvcCorsFilter(ApplicationContext context) {
            HandlerMappingIntrospector mappingIntrospector = new HandlerMappingIntrospector(context);
            return new CorsFilter((CorsConfigurationSource)mappingIntrospector);
        }
    }
}

