/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.util;

import java.security.SecureRandom;
import java.util.Random;

public class RandomValueStringGenerator {
    private static final char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private Random random = new SecureRandom();
    private int length;

    public RandomValueStringGenerator() {
        this(6);
    }

    public RandomValueStringGenerator(int length) {
        this.length = length;
    }

    public String generate() {
        byte[] verifierBytes = new byte[this.length];
        this.random.nextBytes(verifierBytes);
        return this.getAuthorizationCodeString(verifierBytes);
    }

    protected String getAuthorizationCodeString(byte[] verifierBytes) {
        char[] chars = new char[verifierBytes.length];
        int i = 0;
        while (i < verifierBytes.length) {
            chars[i] = DEFAULT_CODEC[(verifierBytes[i] & 0xFF) % DEFAULT_CODEC.length];
            ++i;
        }
        return new String(chars);
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

