/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FrameworkEndpoint
@RequestMapping(value={"/oauth/token"})
public class TokenEndpoint
extends AbstractEndpoint {
    @RequestMapping
    public ResponseEntity<OAuth2AccessToken> getAccessToken(Principal principal, @RequestParam(value="grant_type", required=false) String grantType, @RequestParam Map<String, String> parameters) {
        OAuth2AccessToken token;
        if (!(principal instanceof Authentication)) {
            throw new InsufficientAuthenticationException("There is no client authentication. Try adding an appropriate authentication filter.");
        }
        Authentication client = (Authentication)principal;
        if (!client.isAuthenticated()) {
            throw new InsufficientAuthenticationException("The client is not authenticated.");
        }
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        String clientId = client.getName();
        request.put("client_id", clientId);
        if (!StringUtils.hasText((String)grantType)) {
            throw new InvalidRequestException("Missing grant type");
        }
        this.getAuthorizationRequestManager().validateParameters(parameters, this.getClientDetailsService().loadClientByClientId(clientId));
        DefaultAuthorizationRequest authorizationRequest = new DefaultAuthorizationRequest(this.getAuthorizationRequestManager().createAuthorizationRequest(request));
        if ((this.isAuthCodeRequest(parameters) || this.isRefreshTokenRequest(parameters)) && !authorizationRequest.getScope().isEmpty()) {
            this.logger.debug((Object)"Clearing scope of incoming auth code request");
            authorizationRequest.setScope(Collections.<String>emptySet());
        }
        if (this.isRefreshTokenRequest(parameters)) {
            authorizationRequest.setScope(OAuth2Utils.parseParameterList(parameters.get("scope")));
        }
        if ((token = this.getTokenGranter().grant(grantType, authorizationRequest)) == null) {
            throw new UnsupportedGrantTypeException("Unsupported grant type: " + grantType);
        }
        return this.getResponse(token);
    }

    @ExceptionHandler(value={ClientRegistrationException.class})
    public ResponseEntity<OAuth2Exception> handleClientRegistrationException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        return this.getExceptionTranslator().translate(new BadClientCredentialsException());
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        return this.getExceptionTranslator().translate(e);
    }

    private ResponseEntity<OAuth2AccessToken> getResponse(OAuth2AccessToken accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Pragma", "no-cache");
        return new ResponseEntity((Object)accessToken, (MultiValueMap)headers, HttpStatus.OK);
    }

    private boolean isRefreshTokenRequest(Map<String, String> parameters) {
        return "refresh_token".equals(parameters.get("grant_type")) && parameters.get("refresh_token") != null;
    }

    private boolean isAuthCodeRequest(Map<String, String> parameters) {
        return "authorization_code".equals(parameters.get("grant_type")) && parameters.get("code") != null;
    }
}

