/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.common.OAuthCodec;
import org.springframework.security.oauth.common.OAuthConsumerParameter;
import org.springframework.security.oauth.common.OAuthProviderParameter;
import org.springframework.security.oauth.provider.ConsumerAuthentication;
import org.springframework.security.oauth.provider.ConsumerDetails;
import org.springframework.security.oauth.provider.InvalidOAuthParametersException;
import org.springframework.security.oauth.provider.filter.OAuthProviderProcessingFilter;
import org.springframework.security.oauth.provider.token.OAuthProviderToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessTokenProcessingFilter
extends OAuthProviderProcessingFilter {
    private String responseContentType = "text/plain;charset=utf-8";
    private boolean require10a = true;

    public AccessTokenProcessingFilter() {
        this.setFilterProcessesUrl("/oauth_access_token");
    }

    protected OAuthProviderToken createOAuthToken(ConsumerAuthentication authentication) {
        return this.getTokenServices().createAccessToken(authentication.getConsumerCredentials().getToken());
    }

    @Override
    protected void validateAdditionalParameters(ConsumerDetails consumerDetails, Map<String, String> oauthParams) {
        super.validateAdditionalParameters(consumerDetails, oauthParams);
        String token = oauthParams.get(OAuthConsumerParameter.oauth_token.toString());
        if (token == null) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("AccessTokenProcessingFilter.missingToken", "Missing token."));
        }
        if (this.isRequire10a()) {
            String verifier = oauthParams.get(OAuthConsumerParameter.oauth_verifier.toString());
            if (verifier == null) {
                throw new InvalidOAuthParametersException(this.messages.getMessage("AccessTokenProcessingFilter.missingVerifier", "Missing verifier."));
            }
            OAuthProviderToken requestToken = this.getTokenServices().getToken(token);
            if (!verifier.equals(requestToken.getVerifier())) {
                throw new InvalidOAuthParametersException(this.messages.getMessage("AccessTokenProcessingFilter.missingVerifier", "Invalid verifier."));
            }
        }
    }

    @Override
    protected void onValidSignature(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
        ConsumerAuthentication authentication = (ConsumerAuthentication)SecurityContextHolder.getContext().getAuthentication();
        OAuthProviderToken authToken = this.createOAuthToken(authentication);
        if (!authToken.getConsumerKey().equals(authentication.getConsumerDetails().getConsumerKey())) {
            throw new IllegalStateException("The consumer key associated with the created auth token is not valid for the authenticated consumer.");
        }
        String tokenValue = authToken.getValue();
        StringBuilder responseValue = new StringBuilder(OAuthProviderParameter.oauth_token.toString()).append('=').append(OAuthCodec.oauthEncode(tokenValue)).append('&').append(OAuthProviderParameter.oauth_token_secret.toString()).append('=').append(OAuthCodec.oauthEncode(authToken.getSecret()));
        response.setContentType(this.getResponseContentType());
        response.getWriter().print(responseValue.toString());
        response.flushBuffer();
    }

    @Override
    protected void onNewTimestamp() throws AuthenticationException {
        throw new InvalidOAuthParametersException(this.messages.getMessage("AccessTokenProcessingFilter.timestampNotNew", "A new timestamp should not be used in a request for an access token."));
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public boolean isRequire10a() {
        return this.require10a;
    }

    public void setRequire10a(boolean require10a) {
        this.require10a = require10a;
    }
}

